/*
 * Decompiled with CFR 0.152.
 */
package de.rpjosh.rpdb.headless.console;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$1;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$Kernel32;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$Kernel32Defs;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$Libc;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$Msvcrt;
import de.rpjosh.rpdb.headless.console.RawConsoleInput$Termios;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import o.cs;
import o.ct;

public class RawConsoleInput {
    private static final boolean isWindows = cs.a() == ct.b;
    private static final int invalidKey = 65534;
    private static final String invalidKeyStr = "\ufffe";
    private static boolean initDone;
    private static boolean stdinIsConsole;
    private static boolean consoleModeAltered;
    private static RawConsoleInput$Msvcrt msvcrt;
    private static RawConsoleInput$Kernel32 kernel32;
    private static Pointer consoleHandle;
    private static int originalConsoleMode;
    private static final int stdinFd = 0;
    private static RawConsoleInput$Libc libc;
    private static CharsetDecoder charsetDecoder;
    private static RawConsoleInput$Termios originalTermios;
    private static RawConsoleInput$Termios rawTermios;
    private static RawConsoleInput$Termios intermediateTermios;

    public static int read(boolean bl2) throws IOException {
        if (isWindows) {
            return RawConsoleInput.readWindows(bl2);
        }
        return RawConsoleInput.readUnix(bl2);
    }

    public static void resetConsoleMode() throws IOException {
        if (isWindows) {
            RawConsoleInput.resetConsoleModeWindows();
            return;
        }
        RawConsoleInput.resetConsoleModeUnix();
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new RawConsoleInput$1());
    }

    static void shutdownHook() {
        try {
            RawConsoleInput.resetConsoleMode();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static int readWindows(boolean n2) throws IOException {
        RawConsoleInput.initWindows();
        if (!stdinIsConsole) {
            n2 = msvcrt.getwchar();
            if (n2 == 65535) {
                n2 = -1;
            }
            return (int)n2;
        }
        consoleModeAltered = true;
        RawConsoleInput.setConsoleMode(consoleHandle, originalConsoleMode & 0xFFFFFFFE);
        if (!n2 && msvcrt._kbhit() == 0) {
            return -2;
        }
        return RawConsoleInput.getwch();
    }

    private static int getwch() {
        int n2 = msvcrt._getwch();
        if (n2 == 0 || n2 == 224) {
            n2 = msvcrt._getwch();
            if (n2 >= 0 && n2 <= 6399) {
                return 57344 + n2;
            }
            return 65534;
        }
        if (n2 < 0 || n2 > 65535) {
            return 65534;
        }
        return n2;
    }

    private static synchronized void initWindows() throws IOException {
        if (initDone) {
            return;
        }
        msvcrt = Native.load("msvcrt", RawConsoleInput$Msvcrt.class);
        kernel32 = Native.load("kernel32", RawConsoleInput$Kernel32.class);
        try {
            consoleHandle = RawConsoleInput.getStdInputHandle();
            originalConsoleMode = RawConsoleInput.getConsoleMode(consoleHandle);
            stdinIsConsole = true;
        }
        catch (IOException iOException) {
            stdinIsConsole = false;
        }
        if (stdinIsConsole) {
            RawConsoleInput.registerShutdownHook();
        }
        initDone = true;
    }

    private static Pointer getStdInputHandle() throws IOException {
        Pointer pointer = kernel32.GetStdHandle(-10);
        if (Pointer.nativeValue(pointer) == 0L || Pointer.nativeValue(pointer) == RawConsoleInput$Kernel32Defs.INVALID_HANDLE_VALUE) {
            throw new IOException("GetStdHandle(STD_INPUT_HANDLE) failed.");
        }
        return pointer;
    }

    private static int getConsoleMode(Pointer pointer) throws IOException {
        IntByReference intByReference = new IntByReference();
        if (kernel32.GetConsoleMode(pointer, intByReference) == 0) {
            throw new IOException("GetConsoleMode() failed.");
        }
        return intByReference.getValue();
    }

    private static void setConsoleMode(Pointer pointer, int n2) throws IOException {
        if (kernel32.SetConsoleMode(pointer, n2) == 0) {
            throw new IOException("SetConsoleMode() failed.");
        }
    }

    private static void resetConsoleModeWindows() throws IOException {
        if (!(initDone && stdinIsConsole && consoleModeAltered)) {
            return;
        }
        RawConsoleInput.setConsoleMode(consoleHandle, originalConsoleMode);
        consoleModeAltered = false;
    }

    private static int readUnix(boolean bl2) throws IOException {
        RawConsoleInput.initUnix();
        if (!stdinIsConsole) {
            return RawConsoleInput.readSingleCharFromByteStream(System.in);
        }
        consoleModeAltered = true;
        RawConsoleInput.setTerminalAttrs(0, rawTermios);
        try {
            if (!bl2 && System.in.available() == 0) {
                return -2;
            }
            int n2 = RawConsoleInput.readSingleCharFromByteStream(System.in);
            return n2;
        }
        finally {
            RawConsoleInput.setTerminalAttrs(0, intermediateTermios);
        }
    }

    private static RawConsoleInput$Termios getTerminalAttrs(int n2) throws IOException {
        RawConsoleInput$Termios rawConsoleInput$Termios = new RawConsoleInput$Termios();
        try {
            if (libc.tcgetattr(n2, rawConsoleInput$Termios) != 0) {
                throw new RuntimeException("tcgetattr() failed.");
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("tcgetattr() failed.", lastErrorException);
        }
        return rawConsoleInput$Termios;
    }

    private static void setTerminalAttrs(int n2, RawConsoleInput$Termios rawConsoleInput$Termios) throws IOException {
        try {
            if (libc.tcsetattr(n2, 0, rawConsoleInput$Termios) != 0) {
                throw new RuntimeException("tcsetattr() failed.");
            }
            return;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("tcsetattr() failed.", lastErrorException);
        }
    }

    private static int readSingleCharFromByteStream(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4];
        int n3 = 0;
        do {
            if (n3 >= byArray.length) {
                return 65534;
            }
            n2 = inputStream.read();
            if (n2 == -1) {
                return -1;
            }
            byArray[n3++] = (byte)n2;
        } while ((n2 = RawConsoleInput.decodeCharFromBytes(byArray, n3)) == -1);
        return n2;
    }

    private static synchronized int decodeCharFromBytes(byte[] object, int n2) {
        charsetDecoder.reset();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.replaceWith(invalidKeyStr);
        object = ByteBuffer.wrap(object, 0, n2);
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charsetDecoder.decode((ByteBuffer)object, charBuffer, false);
        if (charBuffer.position() == 0) {
            return -1;
        }
        return charBuffer.get(0);
    }

    private static synchronized void initUnix() throws IOException {
        if (initDone) {
            return;
        }
        libc = Native.load("c", RawConsoleInput$Libc.class);
        stdinIsConsole = libc.isatty(0) == 1;
        charsetDecoder = Charset.defaultCharset().newDecoder();
        if (stdinIsConsole) {
            originalTermios = RawConsoleInput.getTerminalAttrs(0);
            rawTermios = new RawConsoleInput$Termios(originalTermios);
            RawConsoleInput.rawTermios.c_lflag &= 0xFFFFFFB4;
            intermediateTermios = new RawConsoleInput$Termios(rawTermios);
            RawConsoleInput.intermediateTermios.c_lflag |= 2;
            RawConsoleInput.registerShutdownHook();
        }
        initDone = true;
    }

    private static void resetConsoleModeUnix() throws IOException {
        if (!(initDone && stdinIsConsole && consoleModeAltered)) {
            return;
        }
        RawConsoleInput.setTerminalAttrs(0, originalTermios);
        consoleModeAltered = false;
    }
}

