/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import java.lang.reflect.Method;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class<?> clazz) {
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            clazz = NativeMappedConverter.getInstance(clazz).nativeType();
        }
        if (clazz.isArray()) {
            return Native.POINTER_SIZE;
        }
        try {
            return Native.getNativeSize(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown native stack allocation size for ".concat(String.valueOf(clazz)));
        }
    }

    @Override
    public String getFunctionName(NativeLibrary nativeLibrary, Method object) {
        String string = ((Method)object).getName();
        int n2 = 0;
        for (Class<?> clazz : ((Method)object).getParameterTypes()) {
            n2 += this.getArgumentNativeStackSize(clazz);
        }
        String string2 = string + "@" + n2;
        try {
            string = nativeLibrary.getFunction(string2, 63).getName();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                string = nativeLibrary.getFunction("_".concat(String.valueOf(string2)), 63).getName();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {}
        }
        return string;
    }
}

