/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Klass;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure$1;
import com.sun.jna.Structure$2;
import com.sun.jna.Structure$3;
import com.sun.jna.Structure$AutoAllocated;
import com.sun.jna.Structure$ByReference;
import com.sun.jna.Structure$ByValue;
import com.sun.jna.Structure$FFIType;
import com.sun.jna.Structure$FieldOrder;
import com.sun.jna.Structure$LayoutInfo;
import com.sun.jna.Structure$NativeStringTracking;
import com.sun.jna.Structure$StructField;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Structure {
    private static final Logger LOG = Logger.getLogger(Structure.class.getName());
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    protected static final int CALCULATE_SIZE = -1;
    static final Map<Class<?>, Structure$LayoutInfo> layoutInfo = new WeakHashMap();
    static final Map<Class<?>, List<String>> fieldOrder = new WeakHashMap();
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private String encoding;
    private int actualAlignType;
    private int structAlignment;
    private Map<String, Structure$StructField> structFields;
    private final Map<String, Structure$NativeStringTracking> nativeStrings = new HashMap<String, Structure$NativeStringTracking>(8);
    private TypeMapper typeMapper;
    private long typeInfo;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private boolean readCalled;
    private static final ThreadLocal<Map<Pointer, Structure>> reads = new Structure$1();
    private static final ThreadLocal<Set<Structure>> busy = new Structure$2();
    private static final Pointer PLACEHOLDER_MEMORY = new Structure$3(0L);

    public Structure() {
        this(0);
    }

    protected Structure(TypeMapper typeMapper) {
        this(null, 0, typeMapper);
    }

    protected Structure(int n2) {
        this(null, n2);
    }

    protected Structure(int n2, TypeMapper typeMapper) {
        this(null, n2, typeMapper);
    }

    protected Structure(Pointer pointer) {
        this(pointer, 0);
    }

    protected Structure(Pointer pointer, int n2) {
        this(pointer, n2, null);
    }

    protected Structure(Pointer pointer, int n2, TypeMapper typeMapper) {
        this.setAlignType(n2);
        Structure structure = this;
        structure.setStringEncoding(Native.getStringEncoding(structure.getClass()));
        this.initializeTypeMapper(typeMapper);
        this.validateFields();
        if (pointer != null) {
            this.useMemory(pointer, 0, true);
        } else {
            this.allocateMemory(-1);
        }
        this.initializeFields();
    }

    Map<String, Structure$StructField> fields() {
        return this.structFields;
    }

    TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    private void initializeTypeMapper(TypeMapper typeMapper) {
        if (typeMapper == null) {
            typeMapper = Native.getTypeMapper(this.getClass());
        }
        this.typeMapper = typeMapper;
        this.layoutChanged();
    }

    private void layoutChanged() {
        if (this.size != -1) {
            this.size = -1;
            if (this.memory instanceof Structure$AutoAllocated) {
                this.memory = null;
            }
            this.ensureAllocated();
        }
    }

    protected void setStringEncoding(String string) {
        this.encoding = string;
    }

    protected String getStringEncoding() {
        return this.encoding;
    }

    protected void setAlignType(int n2) {
        this.alignType = n2;
        if (n2 == 0 && (n2 = Native.getStructureAlignment(this.getClass())) == 0) {
            n2 = Platform.isWindows() ? 3 : 2;
        }
        this.actualAlignType = n2;
        this.layoutChanged();
    }

    protected Memory autoAllocate(int n2) {
        return new Structure$AutoAllocated(n2);
    }

    protected void useMemory(Pointer pointer) {
        this.useMemory(pointer, 0);
    }

    protected void useMemory(Pointer pointer, int n2) {
        this.useMemory(pointer, n2, false);
    }

    void useMemory(Pointer pointer, int n2, boolean bl2) {
        try {
            this.nativeStrings.clear();
            if (this instanceof Structure$ByValue && !bl2) {
                byte[] byArray = new byte[this.size()];
                pointer.read(0L, byArray, 0, byArray.length);
                this.memory.write(0L, byArray, 0, byArray.length);
            } else {
                if (this.size == -1) {
                    this.size = this.calculateSize(false);
                }
                this.memory = this.size != -1 ? pointer.share(n2, this.size) : pointer.share(n2);
            }
            this.array = null;
            this.readCalled = false;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Structure exceeds provided memory bounds", indexOutOfBoundsException);
        }
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    private void ensureAllocated(boolean bl2) {
        if (this.memory == null) {
            this.allocateMemory(bl2);
            return;
        }
        if (this.size == -1) {
            this.size = this.calculateSize(true, bl2);
            if (!(this.memory instanceof Structure$AutoAllocated)) {
                try {
                    this.memory = this.memory.share(0L, this.size);
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Structure exceeds provided memory bounds", indexOutOfBoundsException);
                }
            }
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    private void allocateMemory(boolean bl2) {
        Structure structure = this;
        structure.allocateMemory(structure.calculateSize(true, bl2));
    }

    protected void allocateMemory(int n2) {
        if (n2 == -1) {
            n2 = this.calculateSize(false);
        } else if (n2 <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: ".concat(String.valueOf(n2)));
        }
        if (n2 != -1) {
            if (this.memory == null || this.memory instanceof Structure$AutoAllocated) {
                this.memory = this.autoAllocate(n2);
            }
            this.size = n2;
        }
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    public void clear() {
        this.ensureAllocated();
        this.nativeStrings.clear();
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set<Structure> busy() {
        return busy.get();
    }

    static Map<Pointer, Structure> reading() {
        return reads.get();
    }

    void conditionalAutoRead() {
        if (!this.readCalled) {
            this.autoRead();
        }
    }

    public void read() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.readCalled = true;
        this.ensureAllocated();
        if (!Structure.busy().add(this)) {
            return;
        }
        if (this instanceof Structure$ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            for (Structure$StructField structure$StructField : this.fields().values()) {
                this.readField(structure$StructField);
            }
            Structure.busy().remove(this);
        }
        catch (Throwable throwable) {
            Structure.busy().remove(this);
            if (this instanceof Structure$ByReference && Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
            throw throwable;
        }
        if (this instanceof Structure$ByReference && Structure.reading().get(this.getPointer()) == this) {
            Structure.reading().remove(this.getPointer());
            return;
        }
    }

    protected int fieldOffset(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: ".concat(String.valueOf(string)));
        }
        return structure$StructField.offset;
    }

    public Object readField(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: ".concat(String.valueOf(string)));
        }
        return this.readField(structure$StructField);
    }

    Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception exception) {
            throw new Error("Exception reading field '" + field.getName() + "' in " + this.getClass(), exception);
        }
    }

    void setFieldValue(Field field, Object object) {
        this.setFieldValue(field, object, false);
    }

    private void setFieldValue(Field field, Object object, boolean bl2) {
        try {
            field.set(this, object);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Modifier.isFinal(field.getModifiers())) {
                if (bl2) {
                    throw new UnsupportedOperationException("This VM does not support Structures with final fields (field '" + field.getName() + "' within " + this.getClass() + ")", illegalAccessException);
                }
                throw new UnsupportedOperationException("Attempt to write to read-only field '" + field.getName() + "' within " + this.getClass(), illegalAccessException);
            }
            throw new Error("Unexpectedly unable to write to field '" + field.getName() + "' within " + this.getClass(), illegalAccessException);
        }
    }

    static <T extends Structure> T updateStructureByReference(Class<T> clazz, T object, Pointer pointer) {
        if (pointer == null) {
            object = null;
        } else if (!(object != null && pointer.equals(object.getPointer()) || (object = Structure.reading().get(pointer)) != null && clazz.equals(object.getClass()))) {
            object = Structure.newInstance(clazz, pointer);
            object.conditionalAutoRead();
        } else {
            object.autoRead();
        }
        return object;
    }

    protected Object readField(Structure$StructField structure$StructField) {
        Object object;
        Object object2;
        int n2 = structure$StructField.offset;
        Object object3 = structure$StructField.type;
        FromNativeConverter fromNativeConverter = structure$StructField.readConverter;
        if (fromNativeConverter != null) {
            object3 = fromNativeConverter.nativeType();
        }
        Object object4 = object2 = Structure.class.isAssignableFrom((Class<?>)object3) || Callback.class.isAssignableFrom((Class<?>)object3) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom((Class<?>)object3) || Pointer.class.isAssignableFrom((Class<?>)object3) || NativeMapped.class.isAssignableFrom((Class<?>)object3) || ((Class)object3).isArray() ? this.getFieldValue(structure$StructField.field) : null;
        Object object5 = object3 == String.class ? ((object = this.memory.getPointer(n2)) == null ? null : ((Pointer)object).getString(0L, this.encoding)) : this.memory.getValue(n2, (Class<?>)object3, object2);
        if (fromNativeConverter != null) {
            object5 = fromNativeConverter.fromNative(object5, structure$StructField.context);
            if (object2 != null && object2.equals(object5)) {
                object5 = object2;
            }
        }
        if (object3.equals(String.class) || object3.equals(WString.class)) {
            if (object5 != null) {
                object = new Structure$NativeStringTracking(object5);
                object3 = this.nativeStrings.put(structure$StructField.name, (Structure$NativeStringTracking)object);
                if (object3 != null) {
                    Structure$NativeStringTracking.access$002((Structure$NativeStringTracking)object, Structure$NativeStringTracking.access$000((Structure$NativeStringTracking)object3));
                }
            } else {
                this.nativeStrings.remove(structure$StructField.name);
            }
        }
        this.setFieldValue(structure$StructField.field, object5, true);
        return object5;
    }

    public void write() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.ensureAllocated();
        if (this instanceof Structure$ByValue) {
            this.getTypeInfo();
        }
        if (!Structure.busy().add(this)) {
            return;
        }
        try {
            for (Structure$StructField structure$StructField : this.fields().values()) {
                if (structure$StructField.isVolatile) continue;
                this.writeField(structure$StructField);
            }
            return;
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    public void writeField(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: ".concat(String.valueOf(string)));
        }
        this.writeField(structure$StructField);
    }

    public void writeField(String string, Object object) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: ".concat(String.valueOf(string)));
        }
        this.setFieldValue(structure$StructField.field, object);
        this.writeField(structure$StructField, object);
    }

    protected void writeField(Structure$StructField structure$StructField) {
        if (structure$StructField.isReadOnly) {
            return;
        }
        Object object = this.getFieldValue(structure$StructField.field);
        this.writeField(structure$StructField, object);
    }

    private void writeField(Structure$StructField structure$StructField, Object object) {
        Object object2;
        int n2 = structure$StructField.offset;
        Class<?> clazz = structure$StructField.type;
        Object object3 = structure$StructField.writeConverter;
        if (object3 != null) {
            object = object3.toNative(object, new StructureWriteContext(this, structure$StructField.field));
            clazz = object3.nativeType();
        }
        if (String.class == clazz || WString.class == clazz) {
            if (object != null) {
                object3 = new Structure$NativeStringTracking(object);
                object2 = this.nativeStrings.put(structure$StructField.name, (Structure$NativeStringTracking)object3);
                if (object2 != null && object.equals(Structure$NativeStringTracking.access$100((Structure$NativeStringTracking)object2))) {
                    Structure$NativeStringTracking.access$002((Structure$NativeStringTracking)object3, Structure$NativeStringTracking.access$000((Structure$NativeStringTracking)object2));
                    return;
                }
                object = clazz == WString.class ? new NativeString(object.toString(), true) : new NativeString(object.toString(), this.encoding);
                Structure$NativeStringTracking.access$002((Structure$NativeStringTracking)object3, (NativeString)object);
                object = ((NativeString)object).getPointer();
            } else {
                this.nativeStrings.remove(structure$StructField.name);
            }
        }
        try {
            this.memory.setValue(n2, object, clazz);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object2 = "Structure field \"" + structure$StructField.name + "\" was declared as " + structure$StructField.type + (structure$StructField.type == clazz ? "" : " (native type " + clazz + ")") + ", which is not supported within a Structure";
            throw new IllegalArgumentException((String)object2, illegalArgumentException);
        }
    }

    protected List<String> getFieldOrder() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Class<?> clazz = this.getClass(); clazz != Structure.class; clazz = clazz.getSuperclass()) {
            Structure$FieldOrder structure$FieldOrder = clazz.getAnnotation(Structure$FieldOrder.class);
            if (structure$FieldOrder == null) continue;
            linkedList.addAll(0, Arrays.asList(structure$FieldOrder.value()));
        }
        return Collections.unmodifiableList(linkedList);
    }

    protected void sortFields(List<Field> list, List<String> list2) {
        block0: for (int i2 = 0; i2 < list2.size(); ++i2) {
            String string = list2.get(i2);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Field field = list.get(i3);
                if (!string.equals(field.getName())) continue;
                Collections.swap(list, i2, i3);
                continue block0;
            }
        }
    }

    protected List<Field> getFieldList() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Class<?> clazz = this.getClass();
        while (!clazz.equals(Structure.class)) {
            ArrayList<Field> arrayList2 = new ArrayList<Field>();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                int n2 = fieldArray[i2].getModifiers();
                if (Modifier.isStatic(n2) || !Modifier.isPublic(n2)) continue;
                arrayList2.add(fieldArray[i2]);
            }
            arrayList.addAll(0, arrayList2);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    private List<String> fieldOrder() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, List<String>> map = fieldOrder;
        synchronized (map) {
            List<String> list = fieldOrder.get(clazz);
            if (list == null) {
                list = this.getFieldOrder();
                fieldOrder.put(clazz, list);
            }
            return list;
        }
    }

    public static List<String> createFieldsOrder(List<String> list, String ... stringArray) {
        return Structure.createFieldsOrder(list, Arrays.asList(stringArray));
    }

    public static List<String> createFieldsOrder(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return Collections.unmodifiableList(arrayList);
    }

    public static List<String> createFieldsOrder(String string) {
        return Collections.unmodifiableList(Collections.singletonList(string));
    }

    public static List<String> createFieldsOrder(String ... stringArray) {
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    private static <T extends Comparable<T>> List<T> sort(Collection<? extends T> collection) {
        collection = new ArrayList<T>(collection);
        Collections.sort(collection);
        return collection;
    }

    protected List<Field> getFields(boolean bl2) {
        List<Field> list = this.getFieldList();
        HashSet<String> hashSet = new HashSet<String>();
        for (Field field : list) {
            hashSet.add(field.getName());
        }
        List<String> list2 = this.fieldOrder();
        if (list2.size() != list.size() && list.size() > 1) {
            if (bl2) {
                throw new Error("Structure.getFieldOrder() on " + this.getClass() + (list2.size() < list.size() ? " does not provide enough" : " provides too many") + " names [" + list2.size() + "] (" + Structure.sort(list2) + ") to match declared fields [" + list.size() + "] (" + Structure.sort(hashSet) + ")");
            }
            return null;
        }
        if (!new HashSet(list2).equals(hashSet)) {
            throw new Error("Structure.getFieldOrder() on " + this.getClass() + " returns names (" + Structure.sort(list2) + ") which do not match declared field names (" + Structure.sort(hashSet) + ")");
        }
        this.sortFields(list, list2);
        return list;
    }

    protected int calculateSize(boolean bl2) {
        return this.calculateSize(bl2, false);
    }

    static int size(Class<? extends Structure> clazz) {
        return Structure.size(clazz, null);
    }

    static <T extends Structure> int size(Class<T> clazz, T t2) {
        Structure$LayoutInfo structure$LayoutInfo;
        Map<Class<?>, Structure$LayoutInfo> map = layoutInfo;
        synchronized (map) {
            structure$LayoutInfo = layoutInfo.get(clazz);
        }
        int n2 = structure$LayoutInfo != null && !Structure$LayoutInfo.access$200(structure$LayoutInfo) ? Structure$LayoutInfo.access$300(structure$LayoutInfo) : -1;
        if (n2 == -1) {
            if (t2 == null) {
                t2 = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
            }
            n2 = t2.size();
        }
        return n2;
    }

    int calculateSize(boolean bl2, boolean bl3) {
        Structure$LayoutInfo structure$LayoutInfo;
        int n2 = -1;
        Class<?> clazz = this.getClass();
        Map<Class<?>, Structure$LayoutInfo> map = layoutInfo;
        synchronized (map) {
            structure$LayoutInfo = layoutInfo.get(clazz);
        }
        if (structure$LayoutInfo == null || this.alignType != Structure$LayoutInfo.access$400(structure$LayoutInfo) || this.typeMapper != Structure$LayoutInfo.access$500(structure$LayoutInfo)) {
            structure$LayoutInfo = this.deriveLayout(bl2, bl3);
        }
        if (structure$LayoutInfo != null) {
            this.structAlignment = Structure$LayoutInfo.access$600(structure$LayoutInfo);
            this.structFields = Structure$LayoutInfo.access$700(structure$LayoutInfo);
            if (!Structure$LayoutInfo.access$200(structure$LayoutInfo)) {
                map = layoutInfo;
                synchronized (map) {
                    if (!layoutInfo.containsKey(clazz) || this.alignType != 0 || this.typeMapper != null) {
                        layoutInfo.put(clazz, structure$LayoutInfo);
                    }
                }
            }
            n2 = Structure$LayoutInfo.access$300(structure$LayoutInfo);
        }
        return n2;
    }

    private void validateField(String string, Class<?> clazz) {
        while (true) {
            ToNativeConverter toNativeConverter;
            if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
                clazz = toNativeConverter.nativeType();
                continue;
            }
            if (!clazz.isArray()) break;
            clazz = clazz.getComponentType();
        }
        try {
            this.getNativeSize(clazz);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "Invalid Structure field in " + this.getClass() + ", field name '" + string + "' (" + clazz + "): " + illegalArgumentException.getMessage();
            throw new IllegalArgumentException(string, illegalArgumentException);
        }
    }

    private void validateFields() {
        for (Field field : this.getFieldList()) {
            this.validateField(field.getName(), field.getType());
        }
    }

    private Structure$LayoutInfo deriveLayout(boolean bl2, boolean bl3) {
        int n2 = 0;
        List<Field> list = this.getFields(bl2);
        if (list == null) {
            return null;
        }
        Structure$LayoutInfo structure$LayoutInfo = new Structure$LayoutInfo(null);
        Structure$LayoutInfo.access$402(structure$LayoutInfo, this.alignType);
        Structure$LayoutInfo.access$502(structure$LayoutInfo, this.typeMapper);
        int n3 = 1;
        for (Field field : list) {
            int n4 = field.getModifiers();
            Class<?> clazz = field.getType();
            if (clazz.isArray()) {
                Structure$LayoutInfo.access$202(structure$LayoutInfo, true);
            }
            Structure$StructField structure$StructField = new Structure$StructField();
            new Structure$StructField().isVolatile = Modifier.isVolatile(n4);
            structure$StructField.isReadOnly = Modifier.isFinal(n4);
            if (structure$StructField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException("This VM does not support read-only fields (field '" + field.getName() + "' within " + this.getClass() + ")");
                }
                field.setAccessible(true);
            }
            structure$StructField.field = field;
            structure$StructField.name = field.getName();
            structure$StructField.type = clazz;
            if (Callback.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field.getName() + "' must be an interface");
            }
            if (clazz.isArray() && Structure.class.equals(clazz.getComponentType())) {
                String string = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(string);
            }
            if (Modifier.isPublic(field.getModifiers())) {
                Object object;
                ToNativeConverter toNativeConverter;
                Object object2 = this.getFieldValue(structure$StructField.field);
                if (object2 == null && clazz.isArray()) {
                    if (bl2) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return null;
                }
                Class<Object> clazz2 = clazz;
                if (NativeMapped.class.isAssignableFrom(clazz)) {
                    toNativeConverter = NativeMappedConverter.getInstance(clazz);
                    clazz2 = ((NativeMappedConverter)toNativeConverter).nativeType();
                    structure$StructField.writeConverter = toNativeConverter;
                    structure$StructField.readConverter = toNativeConverter;
                    structure$StructField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    toNativeConverter = this.typeMapper.getToNativeConverter(clazz);
                    object = this.typeMapper.getFromNativeConverter(clazz);
                    if (toNativeConverter != null && object != null) {
                        clazz2 = (object2 = toNativeConverter.toNative(object2, new StructureWriteContext(this, structure$StructField.field))) != null ? object2.getClass() : Pointer.class;
                        structure$StructField.writeConverter = toNativeConverter;
                        structure$StructField.readConverter = object;
                        structure$StructField.context = new StructureReadContext(this, field);
                    } else if (toNativeConverter != null || object != null) {
                        String string = "Structures require bidirectional type conversion for ".concat(String.valueOf(clazz));
                        throw new IllegalArgumentException(string);
                    }
                }
                if (object2 == null) {
                    object2 = this.initializeField(structure$StructField.field, clazz);
                }
                try {
                    structure$StructField.size = this.getNativeSize(clazz2, object2);
                    n3 = this.getNativeAlignment(clazz2, object2, n3 != 0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!bl2 && this.typeMapper == null) {
                        return null;
                    }
                    object = "Invalid Structure field in " + this.getClass() + ", field name '" + structure$StructField.name + "' (" + structure$StructField.type + "): " + illegalArgumentException.getMessage();
                    throw new IllegalArgumentException((String)object, illegalArgumentException);
                }
                if (n3 == 0) {
                    throw new Error("Field alignment is zero for field '" + structure$StructField.name + "' within " + this.getClass());
                }
                Structure$LayoutInfo structure$LayoutInfo2 = structure$LayoutInfo;
                Structure$LayoutInfo.access$602(structure$LayoutInfo2, Math.max(Structure$LayoutInfo.access$600(structure$LayoutInfo2), n3));
                if (n2 % n3 != 0) {
                    n2 += n3 - n2 % n3;
                }
                if (this instanceof Union) {
                    structure$StructField.offset = 0;
                    n2 = Math.max(n2, structure$StructField.size);
                } else {
                    structure$StructField.offset = n2;
                    n2 += structure$StructField.size;
                }
                Structure$LayoutInfo.access$700(structure$LayoutInfo).put(structure$StructField.name, structure$StructField);
            }
            n3 = 0;
        }
        if (n2 > 0) {
            int n5 = this.addPadding(n2, Structure$LayoutInfo.access$600(structure$LayoutInfo));
            if (this instanceof Structure$ByValue && !bl3) {
                this.getTypeInfo();
            }
            Structure$LayoutInfo.access$302(structure$LayoutInfo, n5);
            return structure$LayoutInfo;
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown or zero size (ensure all fields are public)");
    }

    private void initializeFields() {
        for (Field field : this.getFieldList()) {
            try {
                if (field.get(this) != null) continue;
                Field field2 = field;
                this.initializeField(field2, field2.getType());
            }
            catch (Exception exception) {
                throw new Error("Exception reading field '" + field.getName() + "' in " + this.getClass(), exception);
            }
        }
    }

    private Object initializeField(Field object, Class<?> clazz) {
        NativeMapped nativeMapped = null;
        if (Structure.class.isAssignableFrom(clazz) && !Structure$ByReference.class.isAssignableFrom(clazz)) {
            try {
                nativeMapped = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                this.setFieldValue((Field)object, nativeMapped);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = "Can't determine size of nested structure";
                throw new IllegalArgumentException((String)object, illegalArgumentException);
            }
        } else if (NativeMapped.class.isAssignableFrom(clazz)) {
            nativeMapped = NativeMappedConverter.getInstance(clazz).defaultValue();
            this.setFieldValue((Field)object, nativeMapped);
        }
        return nativeMapped;
    }

    private int addPadding(int n2) {
        return this.addPadding(n2, this.structAlignment);
    }

    private int addPadding(int n2, int n3) {
        if (this.actualAlignType != 1 && n2 % n3 != 0) {
            n2 += n3 - n2 % n3;
        }
        return n2;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class<?> clazz, Object object, boolean bl2) {
        int n2;
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            clazz = nativeMappedConverter.nativeType();
            object = nativeMappedConverter.toNative(object, new ToNativeContext());
        }
        int n3 = Native.getNativeSize(clazz, object);
        if (clazz.isPrimitive() || Long.class == clazz || Integer.class == clazz || Short.class == clazz || Character.class == clazz || Byte.class == clazz || Boolean.class == clazz || Float.class == clazz || Double.class == clazz) {
            n2 = n3;
        } else if (Pointer.class.isAssignableFrom(clazz) && !Function.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz) || WString.class == clazz || String.class == clazz) {
            n2 = Native.POINTER_SIZE;
        } else if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure$ByReference.class.isAssignableFrom(clazz)) {
                n2 = Native.POINTER_SIZE;
            } else {
                if (object == null) {
                    object = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                }
                n2 = ((Structure)object).getStructAlignment();
            }
        } else if (clazz.isArray()) {
            n2 = this.getNativeAlignment(clazz.getComponentType(), null, bl2);
        } else {
            throw new IllegalArgumentException("Type " + clazz + " has unknown native alignment");
        }
        if (this.actualAlignType == 1) {
            n2 = 1;
        } else if (this.actualAlignType == 3) {
            n2 = Math.min(8, n2);
        } else if (this.actualAlignType == 2) {
            if (!(bl2 && Platform.isMac() && Platform.isPPC())) {
                n2 = Math.min(Native.MAX_ALIGNMENT, n2);
            }
            if (!bl2 && Platform.isAIX() && (clazz == Double.TYPE || clazz == Double.class)) {
                n2 = 4;
            }
        }
        return n2;
    }

    public String toString() {
        return this.toString(Boolean.getBoolean("jna.dump_memory"));
    }

    public String toString(boolean bl2) {
        return this.toString(0, true, bl2);
    }

    private String format(Class<?> object) {
        object = ((Class)object).getName();
        int n2 = ((String)object).lastIndexOf(".");
        return ((String)object).substring(n2 + 1);
    }

    private String toString(int n2, boolean bl2, boolean bl3) {
        Object object;
        this.ensureAllocated();
        String string = System.getProperty("line.separator");
        Structure structure = this;
        String string2 = structure.format(structure.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            string2 = string2 + " (" + this.size() + " bytes)";
        }
        String string3 = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string3 = string3 + "  ";
        }
        String string4 = string;
        if (!bl2) {
            string4 = "...}";
        } else {
            Iterator<Structure$StructField> iterator = this.fields().values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Object object2 = this.getFieldValue(((Structure$StructField)object).field);
                String string5 = this.format(((Structure$StructField)object).type);
                String string6 = "";
                string4 = string4 + string3;
                if (((Structure$StructField)object).type.isArray() && object2 != null) {
                    string5 = this.format(((Structure$StructField)object).type.getComponentType());
                    string6 = "[" + Array.getLength(object2) + "]";
                }
                string4 = string4 + String.format("  %s %s%s@0x%X", string5, ((Structure$StructField)object).name, string6, ((Structure$StructField)object).offset);
                if (object2 instanceof Structure) {
                    object2 = ((Structure)object2).toString(n2 + 1, !(object2 instanceof Structure$ByReference), bl3);
                }
                string4 = string4 + "=";
                string4 = object2 instanceof Long ? string4 + String.format("0x%08X", (Long)object2) : (object2 instanceof Integer ? string4 + String.format("0x%04X", (Integer)object2) : (object2 instanceof Short ? string4 + String.format("0x%02X", (Short)object2) : (object2 instanceof Byte ? string4 + String.format("0x%01X", (Byte)object2) : string4 + String.valueOf(object2).trim())));
                string4 = string4 + string;
                if (iterator.hasNext()) continue;
                string4 = string4 + string3 + "}";
            }
        }
        if (n2 == 0 && bl3) {
            string4 = string4 + string + "memory dump" + string;
            object = this.getPointer().getByteArray(0L, this.size());
            for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                if (i3 % 4 == 0) {
                    string4 = string4 + "[";
                }
                if (object[i3] >= 0 && object[i3] < 16) {
                    string4 = string4 + "0";
                }
                string4 = string4 + Integer.toHexString(object[i3] & 0xFF);
                if (i3 % 4 != 3 || i3 >= ((Object)object).length - 1) continue;
                string4 = string4 + "]" + string;
            }
            string4 = string4 + "]";
        }
        return string2 + " {" + string4;
    }

    public Structure[] toArray(Structure[] structureArray) {
        int n2;
        this.ensureAllocated();
        if (this.memory instanceof Structure$AutoAllocated) {
            Memory memory = (Memory)this.memory;
            n2 = structureArray.length * this.size();
            if (memory.size() < (long)n2) {
                Structure structure = this;
                structure.useMemory(structure.autoAllocate(n2));
            }
        }
        structureArray[0] = this;
        int n3 = this.size();
        for (n2 = 1; n2 < structureArray.length; ++n2) {
            structureArray[n2] = Structure.newInstance(this.getClass(), this.memory.share(n2 * n3, n3));
            structureArray[n2].conditionalAutoRead();
        }
        if (!(this instanceof Structure$ByValue)) {
            this.array = structureArray;
        }
        return structureArray;
    }

    public Structure[] toArray(int n2) {
        Structure structure = this;
        return structure.toArray((Structure[])Array.newInstance(structure.getClass(), n2));
    }

    private Class<?> baseClass() {
        if ((this instanceof Structure$ByReference || this instanceof Structure$ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean dataEquals(Structure structure) {
        return this.dataEquals(structure, false);
    }

    public boolean dataEquals(Structure object, boolean bl2) {
        byte[] byArray;
        if (bl2) {
            ((Structure)object).getPointer().clear(((Structure)object).size());
            ((Structure)object).write();
            this.getPointer().clear(this.size());
            this.write();
        }
        if (((Object)(object = (Object)((Structure)object).getPointer().getByteArray(0L, ((Structure)object).size()))).length == (byArray = this.getPointer().getByteArray(0L, this.size())).length) {
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                if (object[i2] == byArray[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Structure && object.getClass() == this.getClass() && ((Structure)object).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        if (this.getPointer() != null) {
            return this.getPointer().hashCode();
        }
        return this.getClass().hashCode();
    }

    protected void cacheTypeInfo(Pointer pointer) {
        this.typeInfo = pointer.peer;
    }

    Structure$FFIType getFieldTypeInfo(Structure$StructField object) {
        ToNativeConverter toNativeConverter;
        Class<?> clazz = ((Structure$StructField)object).type;
        object = this.getFieldValue(((Structure$StructField)object).field);
        if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
            clazz = toNativeConverter.nativeType();
            object = toNativeConverter.toNative(object, new ToNativeContext());
        }
        return Structure$FFIType.access$900(object, clazz);
    }

    Pointer getTypeInfo() {
        Pointer pointer = Structure.getTypeInfo(this).getPointer();
        this.cacheTypeInfo(pointer);
        return pointer;
    }

    public void setAutoSynch(boolean bl2) {
        this.setAutoRead(bl2);
        this.setAutoWrite(bl2);
    }

    public void setAutoRead(boolean bl2) {
        this.autoRead = bl2;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoWrite(boolean bl2) {
        this.autoWrite = bl2;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Structure$FFIType getTypeInfo(Object object) {
        return Structure$FFIType.get(object);
    }

    private static <T extends Structure> T newInstance(Class<T> clazz, long l2) {
        try {
            clazz = Structure.newInstance(clazz, l2 == 0L ? PLACEHOLDER_MEMORY : new Pointer(l2));
            if (l2 != 0L) {
                ((Structure)((Object)clazz)).conditionalAutoRead();
            }
            return (T)clazz;
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "JNA: Error creating structure", throwable);
            return null;
        }
    }

    public static <T extends Structure> T newInstance(Class<T> object, Pointer pointer) throws IllegalArgumentException {
        Constructor<T> constructor;
        try {
            constructor = Structure.getPointerConstructor(object);
            if (constructor != null) {
                return (T)((Structure)constructor.newInstance(pointer));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
            object = "Can't instantiate ".concat(String.valueOf(object));
            throw new IllegalArgumentException((String)object, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = "Instantiation of " + object + " (Pointer) not allowed, is it public?";
            throw new IllegalArgumentException((String)object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = "Exception thrown while instantiating an instance of ".concat(String.valueOf(object));
            throw new IllegalArgumentException((String)object, invocationTargetException);
        }
        constructor = Structure.newInstance(object);
        if (pointer != PLACEHOLDER_MEMORY) {
            ((Structure)((Object)constructor)).useMemory(pointer);
        }
        return (T)constructor;
    }

    public static <T extends Structure> T newInstance(Class<T> object) throws IllegalArgumentException {
        if ((object = (Structure)Klass.newInstance(object)) instanceof Structure$ByValue) {
            ((Structure)object).allocateMemory();
        }
        return (T)object;
    }

    private static <T> Constructor<T> getPointerConstructor(Class<T> constructorArray) {
        for (Constructor<?> constructor : constructorArray.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].equals(Pointer.class)) continue;
            return constructor;
        }
        return null;
    }

    private static void structureArrayCheck(Structure[] object) {
        if (Structure$ByReference[].class.isAssignableFrom(object.getClass())) {
            return;
        }
        Pointer pointer = object[0].getPointer();
        int n2 = object[0].size();
        for (int i2 = 1; i2 < ((Structure[])object).length; ++i2) {
            if (object[i2].getPointer().peer == pointer.peer + (long)(n2 * i2)) continue;
            object = "Structure array elements must use contiguous memory (bad backing address at Structure array index " + i2 + ")";
            throw new IllegalArgumentException((String)object);
        }
    }

    public static void autoRead(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoRead();
            return;
        }
        for (int i2 = 0; i2 < structureArray.length; ++i2) {
            if (structureArray[i2] == null) continue;
            structureArray[i2].autoRead();
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoWrite();
            return;
        }
        for (int i2 = 0; i2 < structureArray.length; ++i2) {
            if (structureArray[i2] == null) continue;
            structureArray[i2].autoWrite();
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoWrite();
                }
            }
        }
    }

    protected int getNativeSize(Class<?> clazz) {
        return this.getNativeSize(clazz, null);
    }

    protected int getNativeSize(Class<?> clazz, Object object) {
        return Native.getNativeSize(clazz, object);
    }

    static void validate(Class<? extends Structure> clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        throw new IllegalArgumentException("No suitable constructor found for class: " + clazz.getName());
    }

    static /* synthetic */ void access$2300(Structure structure, boolean bl2) {
        structure.ensureAllocated(bl2);
    }

    static /* synthetic */ Pointer access$2400() {
        return PLACEHOLDER_MEMORY;
    }
}

