/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.Loader;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final String DELIM_DEFAULT = ":-";
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final int DELIM_DEFAULT_LEN = 2;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String string, Class<?> clazz, Context object) throws IncompatibleClassException, DynamicClassLoadingException {
        object = Loader.getClassLoaderOfObject(object);
        return OptionHelper.instantiateByClassName(string, clazz, (ClassLoader)object);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> clazz, Context object, Class<?> clazz2, Object object2) throws IncompatibleClassException, DynamicClassLoadingException {
        object = Loader.getClassLoaderOfObject(object);
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, (ClassLoader)object, clazz2, object2);
    }

    public static Object instantiateByClassName(String string, Class<?> clazz, ClassLoader classLoader) throws IncompatibleClassException, DynamicClassLoadingException {
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, classLoader, null, null);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> clazz, ClassLoader object, Class<?> clazz2, Object object2) throws IncompatibleClassException, DynamicClassLoadingException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            object = ((ClassLoader)object).loadClass(string);
            if (!clazz.isAssignableFrom((Class<?>)object)) {
                throw new IncompatibleClassException(clazz, (Class<?>)object);
            }
            if (clazz2 == null) {
                return ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return ((Class)object).getConstructor(clazz2).newInstance(object2);
        }
        catch (IncompatibleClassException incompatibleClassException) {
            throw incompatibleClassException;
        }
        catch (Throwable throwable) {
            throw new DynamicClassLoadingException("Failed to instantiate type ".concat(String.valueOf(string)), throwable);
        }
    }

    public static String substVars(String string, PropertyContainer propertyContainer) throws ScanException {
        return OptionHelper.substVars(string, propertyContainer, null);
    }

    public static String substVars(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) throws ScanException {
        return NodeToStringTransformer.substituteVariable(string, propertyContainer, propertyContainer2);
    }

    public static String propertyLookup(String string, PropertyContainer object, PropertyContainer propertyContainer) {
        if ((object = object.getProperty(string)) == null && propertyContainer != null) {
            object = propertyContainer.getProperty(string);
        }
        if (object == null) {
            object = OptionHelper.getSystemProperty(string, null);
        }
        if (object == null) {
            object = OptionHelper.getEnv(string);
        }
        return object;
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static String getEnv(String string) {
        try {
            return System.getenv(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static void setSystemProperties(ContextAware contextAware, Properties properties) {
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            OptionHelper.setSystemProperty(contextAware, string, string2);
        }
    }

    public static void setSystemProperty(ContextAware contextAware, String string, String string2) {
        try {
            System.setProperty(string, string2);
            return;
        }
        catch (SecurityException securityException) {
            contextAware.addError("Failed to set system property [" + string + "]", securityException);
            return;
        }
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException securityException) {
            return new Properties();
        }
    }

    public static String[] extractDefaultReplacement(String string) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        stringArray[0] = string;
        int n2 = string.indexOf(DELIM_DEFAULT);
        if (n2 != -1) {
            stringArray[0] = string.substring(0, n2);
            stringArray[1] = string.substring(n2 + 2);
        }
        return stringArray;
    }

    public static boolean toBoolean(String string, boolean bl2) {
        if (string == null) {
            return bl2;
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        return bl2;
    }

    public static boolean isEmpty(String string) {
        return OptionHelper.isNullOrEmpty(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final boolean isNullOrEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static final boolean isNotEmtpy(Object[] objectArray) {
        return !OptionHelper.isNullOrEmpty(objectArray);
    }
}

