/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetworkAddressUtil
extends ContextAwareBase {
    public NetworkAddressUtil(Context context) {
        this.setContext(context);
    }

    public static String getLocalHostName() throws UnknownHostException, SocketException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return NetworkAddressUtil.getLocalAddressAsString();
        }
    }

    public static String getCanonicalLocalHostName() throws UnknownHostException, SocketException {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return NetworkAddressUtil.getLocalAddressAsString();
        }
    }

    private static String getLocalAddressAsString() throws UnknownHostException, SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (!NetworkAddressUtil.acceptableAddress(inetAddress)) continue;
                return inetAddress.getHostAddress();
            }
        }
        throw new UnknownHostException();
    }

    private static boolean acceptableAddress(InetAddress inetAddress) {
        return inetAddress != null && !inetAddress.isLoopbackAddress() && !inetAddress.isAnyLocalAddress() && !inetAddress.isLinkLocalAddress();
    }

    public String safelyGetLocalHostName() {
        try {
            return NetworkAddressUtil.getLocalHostName();
        }
        catch (SecurityException | SocketException | UnknownHostException exception) {
            this.addError("Failed to get local hostname", exception);
            return "UNKNOWN_LOCALHOST";
        }
    }

    public String safelyGetCanonicalLocalHostName() {
        try {
            return NetworkAddressUtil.getCanonicalLocalHostName();
        }
        catch (SecurityException | SocketException | UnknownHostException exception) {
            this.addError("Failed to get canonical local hostname", exception);
            return "UNKNOWN_LOCALHOST";
        }
    }
}

