/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class COWArrayList<E>
implements List<E> {
    AtomicBoolean fresh = new AtomicBoolean(false);
    CopyOnWriteArrayList<E> underlyingList = new CopyOnWriteArrayList();
    E[] ourCopy;
    final E[] modelArray;

    public COWArrayList(E[] EArray) {
        this.modelArray = EArray;
    }

    @Override
    public int size() {
        return this.underlyingList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.underlyingList.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlyingList.iterator();
    }

    private void refreshCopyIfNecessary() {
        if (!this.isFresh()) {
            this.refreshCopy();
        }
    }

    private boolean isFresh() {
        return this.fresh.get();
    }

    private void refreshCopy() {
        this.ourCopy = this.underlyingList.toArray(this.modelArray);
        this.fresh.set(true);
    }

    @Override
    public Object[] toArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    public E[] asTypedArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    private void markAsStale() {
        this.fresh.set(false);
    }

    public void addIfAbsent(E e2) {
        this.underlyingList.addIfAbsent(e2);
        this.markAsStale();
    }

    @Override
    public boolean add(E e2) {
        boolean bl2 = this.underlyingList.add(e2);
        this.markAsStale();
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl2 = this.underlyingList.remove(object);
        this.markAsStale();
        return bl2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.underlyingList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.markAsStale();
        return this.underlyingList.addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.markAsStale();
        return this.underlyingList.addAll(n2, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.markAsStale();
        return this.underlyingList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.markAsStale();
        return this.underlyingList.retainAll(collection);
    }

    @Override
    public void clear() {
        this.markAsStale();
        this.underlyingList.clear();
    }

    @Override
    public E get(int n2) {
        this.refreshCopyIfNecessary();
        return this.ourCopy[n2];
    }

    @Override
    public E set(int n2, E e2) {
        this.markAsStale();
        return this.underlyingList.set(n2, e2);
    }

    @Override
    public void add(int n2, E e2) {
        this.markAsStale();
        this.underlyingList.add(n2, e2);
    }

    @Override
    public E remove(int n2) {
        this.markAsStale();
        return this.underlyingList.remove(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.underlyingList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.underlyingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.underlyingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return this.underlyingList.listIterator(n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return this.underlyingList.subList(n2, n3);
    }
}

