/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;

public class ContextAwareImpl
implements ContextAware {
    private int noContextWarning = 0;
    protected Context context;
    final Object origin;

    public ContextAwareImpl(Context context, Object object) {
        this.context = context;
        this.origin = object;
    }

    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == null) {
            this.context = context;
            return;
        }
        if (this.context != context) {
            throw new IllegalStateException("Context has been already set");
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public StatusManager getStatusManager() {
        if (this.context == null) {
            return null;
        }
        return this.context.getStatusManager();
    }

    @Override
    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for ".concat(String.valueOf(this)));
            }
            return;
        }
        StatusManager statusManager = this.context.getStatusManager();
        if (statusManager != null) {
            statusManager.add(status);
        }
    }

    @Override
    public void addInfo(String string) {
        this.addStatus(new InfoStatus(string, this.getOrigin()));
    }

    @Override
    public void addInfo(String string, Throwable throwable) {
        this.addStatus(new InfoStatus(string, this.getOrigin(), throwable));
    }

    @Override
    public void addWarn(String string) {
        this.addStatus(new WarnStatus(string, this.getOrigin()));
    }

    @Override
    public void addWarn(String string, Throwable throwable) {
        this.addStatus(new WarnStatus(string, this.getOrigin(), throwable));
    }

    @Override
    public void addError(String string) {
        this.addStatus(new ErrorStatus(string, this.getOrigin()));
    }

    @Override
    public void addError(String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, this.getOrigin(), throwable));
    }
}

