/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover$ArhiveRemoverRunnable;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Future;

public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    @Override
    public void clean(Date date) {
        long l2 = date.getTime();
        int n2 = this.computeElapsedPeriodsSinceLastClean(l2);
        this.lastHeartBeat = l2;
        if (n2 > 1) {
            this.addInfo("Multiple periods, i.e. " + n2 + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getPeriodOffsetForDeletionTarget() - i2;
            Date date2 = this.rc.getEndOfNextNthPeriod(date, n3);
            this.cleanPeriod(date2);
        }
    }

    protected File[] getFilesInPeriod(Date object) {
        object = this.fileNamePattern.convert(object);
        if (this.fileExistsAndIsFile((File)(object = new File((String)object)))) {
            return new File[]{object};
        }
        return new File[0];
    }

    private boolean fileExistsAndIsFile(File file) {
        return file.exists() && file.isFile();
    }

    public void cleanPeriod(Date fileArray) {
        Object object = fileArray = this.getFilesInPeriod((Date)fileArray);
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = object[i2];
            this.addInfo("deleting ".concat(String.valueOf(file)));
            file.delete();
        }
        if (this.parentClean && fileArray.length > 0) {
            object = this.getParentDir(fileArray[0]);
            this.removeFolderIfEmpty((File)object);
        }
    }

    void capTotalSize(Date date) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.maxHistory; ++i2) {
            File[] fileArray = this.rc.getEndOfNextNthPeriod(date, -i2);
            File[] fileArray2 = this.getFilesInPeriod((Date)fileArray);
            this.descendingSort(fileArray2, (Date)fileArray);
            fileArray = fileArray2;
            int n2 = fileArray2.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                File file = fileArray[i3];
                long l4 = file.length();
                if (l2 + l4 > this.totalSizeCap) {
                    this.addInfo("Deleting [" + file + "] of size " + new FileSize(l4));
                    l3 += l4;
                    file.delete();
                }
                l2 += l4;
            }
        }
        this.addInfo("Removed  " + new FileSize(l3) + " of files");
    }

    protected void descendingSort(File[] fileArray, Date date) {
    }

    File getParentDir(File file) {
        return file.getAbsoluteFile().getParentFile();
    }

    int computeElapsedPeriodsSinceLastClean(long l2) {
        long l3;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            long l4 = l2;
            l3 = Math.min(this.rc.periodBarriersCrossed(l4, l4 + 2764800000L), 336L);
        } else {
            l3 = this.rc.periodBarriersCrossed(this.lastHeartBeat, l2);
        }
        return (int)l3;
    }

    boolean computeParentCleaningFlag(FileNamePattern converter) {
        if (((FileNamePattern)((Object)converter)).getPrimaryDateTokenConverter().getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = ((FileNamePattern)((Object)converter)).headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            if (converter instanceof LiteralConverter && converter.convert(null).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n2) {
        while (true) {
            if (n2 >= 3) {
                return;
            }
            if (!file.isDirectory() || !FileFilterUtil.isEmptyDirectory(file)) break;
            this.addInfo("deleting folder [" + file + "]");
            file.delete();
            ++n2;
            file = file.getParentFile();
        }
    }

    @Override
    public void setMaxHistory(int n2) {
        this.maxHistory = n2;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    @Override
    public void setTotalSizeCap(long l2) {
        this.totalSizeCap = l2;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    @Override
    public Future<?> cleanAsynchronously(Date object) {
        object = new TimeBasedArchiveRemover$ArhiveRemoverRunnable(this, (Date)object);
        return this.context.getScheduledExecutorService().submit((Runnable)object);
    }

    static /* synthetic */ long access$000(TimeBasedArchiveRemover timeBasedArchiveRemover) {
        return timeBasedArchiveRemover.totalSizeCap;
    }
}

