/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

public class RecoveryCoordinator {
    public static final long BACKOFF_COEFFICIENT_MIN = 20L;
    public static final long BACKOFF_MULTIPLIER = 4L;
    static long BACKOFF_COEFFICIENT_MAX = 327680L;
    private long backOffCoefficient = 20L;
    private static long UNSET = -1L;
    private long currentTime = UNSET;
    private long next;

    public RecoveryCoordinator() {
        this.next = this.getCurrentTime() + this.getBackoffCoefficient();
    }

    public RecoveryCoordinator(long l2) {
        this.currentTime = l2;
        this.next = this.getCurrentTime() + this.getBackoffCoefficient();
    }

    public boolean isTooSoon() {
        long l2 = this.getCurrentTime();
        if (l2 > this.next) {
            this.next = l2 + this.getBackoffCoefficient();
            return false;
        }
        return true;
    }

    void setCurrentTime(long l2) {
        this.currentTime = l2;
    }

    private long getCurrentTime() {
        if (this.currentTime != UNSET) {
            return this.currentTime;
        }
        return System.currentTimeMillis();
    }

    private long getBackoffCoefficient() {
        long l2 = this.backOffCoefficient;
        if (this.backOffCoefficient < BACKOFF_COEFFICIENT_MAX) {
            this.backOffCoefficient *= 4L;
        }
        return l2;
    }
}

