/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> converter) {
        while (converter != null) {
            if (converter instanceof CompositeConverter) {
                CompositeConverter compositeConverter = (CompositeConverter)converter;
                ConverterUtil.startConverters(compositeConverter.childConverter);
                compositeConverter.start();
            } else if (converter instanceof DynamicConverter) {
                ((DynamicConverter)converter).start();
            }
            converter = converter.getNext();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> converter) {
        Converter<E> converter2;
        while (converter != null && (converter2 = converter.getNext()) != null) {
            converter = converter2;
        }
        return converter;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> converter) {
        while (converter != null) {
            if (converter instanceof ContextAware) {
                ((ContextAware)((Object)converter)).setContext(context);
            }
            if (converter instanceof CompositeConverter) {
                Converter converter2 = ((CompositeConverter)converter).childConverter;
                ConverterUtil.setContextForConverters(context, converter2);
            }
            converter = converter.getNext();
        }
    }
}

