/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.IfModel$BranchState;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public class IfModelHandler
extends ModelHandlerBase {
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also http://logback.qos.ch/codes.html#ifJanino";
    IfModel ifModel = null;

    public IfModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IfModelHandler(context);
    }

    public Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model object2) throws ModelHandlerException {
        this.ifModel = (IfModel)object2;
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        ((ModelInterpretationContext)object).pushModel(this.ifModel);
        object2 = this.ifModel.getCondition();
        if (!OptionHelper.isNullOrEmpty((String)object2)) {
            try {
                object2 = OptionHelper.substVars((String)object2, (PropertyContainer)object, this.context);
            }
            catch (ScanException scanException) {
                this.addError("Failed to parse input [" + (String)object2 + "]", scanException);
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                return;
            }
            object = new PropertyEvalScriptBuilder((PropertyContainer)object);
            ((ContextAwareBase)object).setContext(this.context);
            try {
                object = ((PropertyEvalScriptBuilder)object).build((String)object2);
            }
            catch (Exception exception) {
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                this.addError("Failed to parse condition [" + (String)object2 + "]", exception);
                return;
            }
            if (object != null) {
                boolean bl2 = object.evaluate();
                this.ifModel.setBranchState(bl2);
                return;
            }
            this.addError("The condition variable is null. This should not occur.");
            this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
            return;
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        model = modelInterpretationContext.peekModel();
        if (model != this.ifModel) {
            this.addWarn("The object [" + model + "] on the top the of the stack is not the expected [" + this.ifModel);
            return;
        }
        modelInterpretationContext.popModel();
    }
}

