/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.EventEvaluatorModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class EventEvaluatorModelHandler
extends ModelHandlerBase {
    EventEvaluator<?> evaluator;
    boolean inError = false;

    public EventEvaluatorModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new EventEvaluatorModelHandler(context);
    }

    protected Class<EventEvaluatorModel> getSupportedModelClass() {
        return EventEvaluatorModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        String string;
        String string2 = ((ComponentModel)(model = (EventEvaluatorModel)model)).getClassName();
        if (OptionHelper.isNullOrEmpty(string2)) {
            string = this.defaultClassName(modelInterpretationContext, (EventEvaluatorModel)model);
            if (OptionHelper.isNullOrEmpty(string)) {
                this.inError = true;
                this.addError("Mandatory \"class\" attribute missing for <evaluator>");
                this.addError("No default classname could be found.");
                return;
            }
            this.addInfo("Assuming default evaluator class [" + string + "]");
            string2 = string;
        } else {
            string2 = modelInterpretationContext.getImport(string2);
        }
        string = modelInterpretationContext.subst(((NamedComponentModel)model).getName());
        try {
            this.evaluator = (EventEvaluator)OptionHelper.instantiateByClassName(string2, EventEvaluator.class, this.context);
            this.evaluator.setContext(this.context);
            this.evaluator.setName(string);
            modelInterpretationContext.pushObject(this.evaluator);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create evaluator of type " + string2 + "].", exception);
            return;
        }
    }

    private String defaultClassName(ModelInterpretationContext modelInterpretationContext, EventEvaluatorModel eventEvaluatorModel) {
        return modelInterpretationContext.getDefaultNestedComponentRegistry().findDefaultComponentTypeByTag(eventEvaluatorModel.getTag());
    }

    @Override
    public void postHandle(ModelInterpretationContext object, Model model) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        if (this.evaluator instanceof LifeCycle) {
            this.evaluator.start();
            this.addInfo("Starting evaluator named [" + this.evaluator.getName() + "]");
        }
        if (((ModelInterpretationContext)object).peekObject() != this.evaluator) {
            this.addWarn("The object on the top the of the stack is not the evaluator pushed earlier.");
            return;
        }
        ((ModelInterpretationContext)object).popObject();
        try {
            object = (Map)this.context.getObject("EVALUATOR_MAP");
            if (object == null) {
                this.addError("Could not find EvaluatorMap");
                return;
            }
            object.put(this.evaluator.getName(), this.evaluator);
            return;
        }
        catch (Exception exception) {
            this.addError("Could not set evaluator named [" + this.evaluator + "].", exception);
            return;
        }
    }
}

