/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    private String attributeInUse;
    private boolean optional;
    Model parentModel;
    IncludeModel includeModel;
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext saxEventInterpretationContext, String object, Attributes attributes) throws ActionException {
        this.parentModel = null;
        this.includeModel = null;
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        String string = attributes.getValue(OPTIONAL_ATTR);
        this.createModelForAlternateUse(saxEventInterpretationContext, (String)object, attributes, string);
        this.attributeInUse = null;
        this.optional = OptionHelper.toBoolean(string, false);
        if (!this.checkAttributes(attributes)) {
            this.inError = true;
            return;
        }
        object = this.getInputStream(saxEventInterpretationContext, attributes);
        try {
            if (object != null) {
                this.parseAndRecord((InputStream)object, saxEventRecorder);
                this.trimHeadAndTail(saxEventRecorder);
                saxEventInterpretationContext.getSaxEventInterpreter().getEventPlayer().addEventsDynamically(saxEventRecorder.getSaxEventList(), 2);
            }
            return;
        }
        catch (JoranException joranException) {
            this.addError("Error while parsing  " + this.attributeInUse, joranException);
            return;
        }
        finally {
            this.close((InputStream)object);
        }
    }

    private void createModelForAlternateUse(SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes, String string2) {
        this.includeModel = new IncludeModel();
        this.includeModel.setOptional(string2);
        IncludeAction includeAction = this;
        includeAction.fillInIncludeModelAttributes(includeAction.includeModel, string, attributes);
        if (!saxEventInterpretationContext.isModelStackEmpty()) {
            this.parentModel = saxEventInterpretationContext.peekModel();
        }
        int n2 = IncludeAction.getLineNumber(saxEventInterpretationContext);
        this.includeModel.setLineNumber(n2);
        saxEventInterpretationContext.pushModel(this.includeModel);
    }

    private void fillInIncludeModelAttributes(IncludeModel object, String string, Attributes object2) {
        this.includeModel.setTag(string);
        object = object2.getValue(FILE_ATTR);
        string = object2.getValue(URL_ATTR);
        object2 = object2.getValue(RESOURCE_ATTR);
        this.includeModel.setFile((String)object);
        this.includeModel.setUrl(string);
        this.includeModel.setResource((String)object2);
    }

    void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private boolean checkAttributes(Attributes object) {
        String string = object.getValue(FILE_ATTR);
        String string2 = object.getValue(URL_ATTR);
        object = object.getValue(RESOURCE_ATTR);
        int n2 = 0;
        if (!OptionHelper.isNullOrEmpty(string)) {
            ++n2;
        }
        if (!OptionHelper.isNullOrEmpty(string2)) {
            ++n2;
        }
        if (!OptionHelper.isNullOrEmpty((String)object)) {
            ++n2;
        }
        if (n2 == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (n2 > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n2 + "] is not expected");
    }

    URL attributeToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            string = "URL [" + string + "] is not well formed.";
            this.addError(string, malformedURLException);
            return null;
        }
    }

    InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            this.optionalWarning("Failed to open [" + uRL.toString() + "]");
            return null;
        }
    }

    URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.optionalWarning("Could not find resource corresponding to [" + string + "]");
            return null;
        }
        return uRL;
    }

    private void optionalWarning(String string) {
        if (!this.optional) {
            this.addWarn(string);
        }
    }

    URL filePathAsURL(String object) {
        object = new File((String)object).toURI();
        try {
            return ((URI)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    URL getInputURL(SaxEventInterpretationContext saxEventInterpretationContext, Attributes object) {
        String string = object.getValue(FILE_ATTR);
        String string2 = object.getValue(URL_ATTR);
        object = object.getValue(RESOURCE_ATTR);
        if (!OptionHelper.isNullOrEmpty(string)) {
            this.attributeInUse = saxEventInterpretationContext.subst(string);
            IncludeAction includeAction = this;
            return includeAction.filePathAsURL(includeAction.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty(string2)) {
            this.attributeInUse = saxEventInterpretationContext.subst(string2);
            IncludeAction includeAction = this;
            return includeAction.attributeToURL(includeAction.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty((String)object)) {
            this.attributeInUse = saxEventInterpretationContext.subst((String)object);
            IncludeAction includeAction = this;
            return includeAction.resourceAsURL(includeAction.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    InputStream getInputStream(SaxEventInterpretationContext object, Attributes attributes) {
        if ((object = this.getInputURL((SaxEventInterpretationContext)object, attributes)) == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, (URL)object);
        return this.openURL((URL)object);
    }

    private void trimHeadAndTail(SaxEventRecorder object) {
        if ((object = ((SaxEventRecorder)object).getSaxEventList()).size() == 0) {
            return;
        }
        SaxEvent saxEvent = (SaxEvent)object.get(0);
        if (saxEvent != null && saxEvent.qName.equalsIgnoreCase("included")) {
            object.remove(0);
        }
        Object object2 = object;
        saxEvent = (SaxEvent)object2.get(object2.size() - 1);
        if (saxEvent != null && saxEvent.qName.equalsIgnoreCase("included")) {
            Object object3 = object;
            object3.remove(object3.size() - 1);
        }
    }

    private void parseAndRecord(InputStream inputStream, SaxEventRecorder saxEventRecorder) throws JoranException {
        saxEventRecorder.setContext(this.context);
        saxEventRecorder.recordEvents(inputStream);
    }

    @Override
    public void end(SaxEventInterpretationContext saxEventInterpretationContext, String string) throws ActionException {
        if (this.inError) {
            return;
        }
        if (saxEventInterpretationContext.peekModel() != this.includeModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.includeModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.includeModel);
            saxEventInterpretationContext.popModel();
        }
    }
}

