/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.filter;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;

public class EvaluatorFilter<E>
extends AbstractMatcherFilter<E> {
    EventEvaluator<E> evaluator;

    @Override
    public void start() {
        if (this.evaluator != null) {
            super.start();
            return;
        }
        this.addError("No evaluator set for filter " + this.getName());
    }

    public EventEvaluator<E> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        this.evaluator = eventEvaluator;
    }

    @Override
    public FilterReply decide(E e2) {
        if (!this.isStarted() || !this.evaluator.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        try {
            if (this.evaluator.evaluate(e2)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        catch (EvaluationException evaluationException) {
            this.addError("Evaluator " + this.evaluator.getName() + " threw an exception", evaluationException);
            return FilterReply.NEUTRAL;
        }
    }
}

