/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.WarnStatus;
import java.util.List;

public abstract class UnsynchronizedAppenderBase<E>
extends ContextAwareBase
implements Appender<E> {
    protected boolean started = false;
    private ThreadLocal<Boolean> guard = new ThreadLocal();
    protected String name;
    private FilterAttachableImpl<E> fai = new FilterAttachableImpl();
    private int statusRepeatCount = 0;
    private int exceptionCount = 0;
    static final int ALLOWED_REPEATS = 3;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void doAppend(E e2) {
        if (Boolean.TRUE.equals(this.guard.get())) {
            return;
        }
        try {
            this.guard.set(Boolean.TRUE);
            if (!this.started) {
                if (this.statusRepeatCount++ < 3) {
                    this.addStatus(new WarnStatus("Attempted to append to non started appender [" + this.name + "].", this));
                }
                return;
            }
            if (this.getFilterChainDecision(e2) == FilterReply.DENY) {
                return;
            }
            this.append(e2);
            return;
        }
        catch (Exception exception) {
            if (this.exceptionCount++ < 3) {
                this.addError("Appender [" + this.name + "] failed to append.", exception);
            }
            return;
        }
        finally {
            this.guard.set(Boolean.FALSE);
        }
    }

    protected abstract void append(E var1);

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    @Override
    public void addFilter(Filter<E> filter) {
        this.fai.addFilter(filter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<E>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(E e2) {
        return this.fai.getFilterChainDecision(e2);
    }
}

