/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.helpers.MessageFormatter;

public class LoggingEventVO
implements ILoggingEvent,
Serializable {
    private static final long serialVersionUID = 6553722650255690312L;
    private static final int NULL_ARGUMENT_ARRAY = -1;
    private static final String NULL_ARGUMENT_ARRAY_ELEMENT = "NULL_ARGUMENT_ARRAY_ELEMENT";
    private String threadName;
    private String loggerName;
    private LoggerContextVO loggerContextVO;
    private transient Level level;
    private String message;
    private transient String formattedMessage;
    private transient Object[] argumentArray;
    private ThrowableProxyVO throwableProxy;
    private StackTraceElement[] callerDataArray;
    private List<Marker> markerList;
    private List<KeyValuePair> keyValuePairList;
    private Map<String, String> mdcPropertyMap;
    private long timeStamp;
    private long sequenceNumber;

    public static LoggingEventVO build(ILoggingEvent iLoggingEvent) {
        LoggingEventVO loggingEventVO = new LoggingEventVO();
        new LoggingEventVO().loggerName = iLoggingEvent.getLoggerName();
        loggingEventVO.loggerContextVO = iLoggingEvent.getLoggerContextVO();
        loggingEventVO.threadName = iLoggingEvent.getThreadName();
        loggingEventVO.level = iLoggingEvent.getLevel();
        loggingEventVO.message = iLoggingEvent.getMessage();
        loggingEventVO.argumentArray = iLoggingEvent.getArgumentArray();
        loggingEventVO.markerList = iLoggingEvent.getMarkerList();
        loggingEventVO.keyValuePairList = iLoggingEvent.getKeyValuePairs();
        loggingEventVO.mdcPropertyMap = iLoggingEvent.getMDCPropertyMap();
        loggingEventVO.timeStamp = iLoggingEvent.getTimeStamp();
        loggingEventVO.sequenceNumber = iLoggingEvent.getSequenceNumber();
        loggingEventVO.throwableProxy = ThrowableProxyVO.build(iLoggingEvent.getThrowableProxy());
        if (iLoggingEvent.hasCallerData()) {
            loggingEventVO.callerDataArray = iLoggingEvent.getCallerData();
        }
        return loggingEventVO;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat(this.message, this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    @Override
    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    @Override
    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    @Override
    public StackTraceElement[] getCallerData() {
        return this.callerDataArray;
    }

    @Override
    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    @Override
    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    public LoggerContextVO getContextLoggerRemoteView() {
        return this.loggerContextVO;
    }

    @Override
    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    @Override
    public Map<String, String> getMdc() {
        return this.mdcPropertyMap;
    }

    @Override
    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairList;
    }

    @Override
    public void prepareForDeferredProcessing() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.level.levelInt);
        if (this.argumentArray != null) {
            int n2 = this.argumentArray.length;
            objectOutputStream.writeInt(n2);
            for (n2 = 0; n2 < this.argumentArray.length; ++n2) {
                if (this.argumentArray[n2] != null) {
                    objectOutputStream.writeObject(this.argumentArray[n2].toString());
                    continue;
                }
                objectOutputStream.writeObject(NULL_ARGUMENT_ARRAY_ELEMENT);
            }
            return;
        }
        objectOutputStream.writeInt(-1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.level = Level.toLevel(n2);
        n2 = objectInputStream.readInt();
        if (n2 != -1) {
            this.argumentArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectInputStream.readObject();
                if (NULL_ARGUMENT_ARRAY_ELEMENT.equals(object)) continue;
                this.argumentArray[i2] = object;
            }
        }
    }

    public int hashCode() {
        int n2 = 31 + (this.message == null ? 0 : this.message.hashCode());
        n2 = 31 * n2 + (this.threadName == null ? 0 : this.threadName.hashCode());
        return 31 * n2 + (int)(this.timeStamp ^ this.timeStamp >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (LoggingEventVO)object;
        if (this.message == null ? ((LoggingEventVO)object).message != null : !this.message.equals(((LoggingEventVO)object).message)) {
            return false;
        }
        if (this.loggerName == null ? ((LoggingEventVO)object).loggerName != null : !this.loggerName.equals(((LoggingEventVO)object).loggerName)) {
            return false;
        }
        if (this.threadName == null ? ((LoggingEventVO)object).threadName != null : !this.threadName.equals(((LoggingEventVO)object).threadName)) {
            return false;
        }
        if (this.timeStamp != ((LoggingEventVO)object).timeStamp) {
            return false;
        }
        if (this.markerList == null ? ((LoggingEventVO)object).markerList != null : !this.markerList.equals(((LoggingEventVO)object).markerList)) {
            return false;
        }
        return !(this.mdcPropertyMap == null ? ((LoggingEventVO)object).mdcPropertyMap != null : !this.mdcPropertyMap.equals(((LoggingEventVO)object).mdcPropertyMap));
    }
}

