/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector.servlet;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.util.JNDIUtil;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import javax.naming.NamingException;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    public void contextDestroyed(ServletContextEvent object) {
        object = null;
        try {
            object = JNDIUtil.lookupString(JNDIUtil.getInitialContext(), "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (object != null) {
            System.out.println("About to detach context named ".concat(String.valueOf(object)));
            ContextSelector contextSelector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
            if (contextSelector == null) {
                System.out.println("Selector is null, cannot detach context. Skipping.");
                return;
            }
            LoggerContext loggerContext = contextSelector.getLoggerContext((String)object);
            if (loggerContext != null) {
                loggerContext.getLogger("ROOT").warn("Stopping logger context ".concat(String.valueOf(object)));
                contextSelector.detachLoggerContext((String)object);
                ((ContextBase)loggerContext).stop();
                return;
            }
            System.out.println("No context named " + (String)object + " was found.");
        }
    }
}

