/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    protected static final int BUILDER_CAPACITY = 2048;
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    List<String> ignoredStackTraceLines = null;
    int errorCount = 0;

    @Override
    public void start() {
        Object object = this.getFirstOption();
        if (object == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(object = ((String)object).toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(object)) {
            this.lengthOption = 1;
        } else {
            try {
                this.lengthOption = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Could not parse [" + (String)object + "] as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        object = this.getOptionList();
        if (object != null && object.size() > 1) {
            int n2 = object.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                String string = (String)object.get(i2);
                EventEvaluator eventEvaluator = (EventEvaluator)((Map)this.getContext().getObject("EVALUATOR_MAP")).get(string);
                if (eventEvaluator != null) {
                    this.addEvaluator(eventEvaluator);
                    continue;
                }
                this.addIgnoreStackTraceLine(string);
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    private void addIgnoreStackTraceLine(String string) {
        if (this.ignoredStackTraceLines == null) {
            this.ignoredStackTraceLines = new ArrayList<String>();
        }
        this.ignoredStackTraceLines.add(string);
    }

    @Override
    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            boolean bl2 = true;
            for (int i2 = 0; i2 < this.evaluatorList.size(); ++i2) {
                Object object = this.evaluatorList.get(i2);
                try {
                    if (!object.evaluate((ILoggingEvent)iLoggingEvent)) continue;
                    bl2 = false;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + object.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    object = new ErrorStatus("Exception thrown for evaluator named [" + object.getName() + "].", this, evaluationException);
                    ((StatusBase)object).add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus((Status)object);
                }
            }
            if (!bl2) {
                return "";
            }
        }
        return this.throwableProxyToString(iThrowableProxy);
    }

    protected String throwableProxyToString(IThrowableProxy iThrowableProxy) {
        StringBuilder stringBuilder = new StringBuilder(2048);
        this.recursiveAppend(stringBuilder, null, 1, iThrowableProxy);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void recursiveAppend(StringBuilder stringBuilder, String object, int n2, IThrowableProxy iThrowableProxy) {
        IThrowableProxy iThrowableProxy2;
        while (iThrowableProxy2 != null) {
            void var3_6;
            void var2_3;
            this.subjoinFirstLine(stringBuilder, (String)var2_3, (int)var3_6, iThrowableProxy2);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            this.subjoinSTEPArray(stringBuilder, (int)var3_6, iThrowableProxy2);
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy2.getSuppressed();
            if (iThrowableProxyArray != null) {
                for (IThrowableProxy iThrowableProxy3 : iThrowableProxyArray) {
                    this.recursiveAppend(stringBuilder, "Suppressed: ", (int)(var3_6 + true), iThrowableProxy3);
                }
            }
            iThrowableProxy2 = iThrowableProxy2.getCause();
            String string = "Caused by: ";
        }
        return;
    }

    private void subjoinFirstLine(StringBuilder stringBuilder, String string, int n2, IThrowableProxy iThrowableProxy) {
        ThrowableProxyUtil.indent(stringBuilder, n2 - 1);
        if (string != null) {
            stringBuilder.append(string);
        }
        this.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    private void subjoinExceptionMessage(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append("[CIRCULAR REFERENCE: ").append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage()).append(']');
            return;
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage());
    }

    protected void subjoinSTEPArray(StringBuilder stringBuilder, int n2, IThrowableProxy iThrowableProxy) {
        int n3;
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n4 = iThrowableProxy.getCommonFrames();
        boolean bl2 = this.lengthOption > stackTraceElementProxyArray.length;
        int n5 = n3 = bl2 ? stackTraceElementProxyArray.length : this.lengthOption;
        if (n4 > 0 && bl2) {
            n3 -= n4;
        }
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i2];
            if (!this.isIgnoredStackTraceLine(stackTraceElementProxy.toString())) {
                ThrowableProxyUtil.indent(stringBuilder, n2);
                this.printStackLine(stringBuilder, n6, stackTraceElementProxy);
                n6 = 0;
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
                continue;
            }
            ++n6;
            if (n3 >= stackTraceElementProxyArray.length) continue;
            ++n3;
        }
        if (n6 > 0) {
            this.printIgnoredCount(stringBuilder, n6);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n4 > 0 && bl2) {
            ThrowableProxyUtil.indent(stringBuilder, n2);
            stringBuilder.append("... ").append(iThrowableProxy.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    private void printStackLine(StringBuilder stringBuilder, int n2, StackTraceElementProxy stackTraceElementProxy) {
        stringBuilder.append(stackTraceElementProxy);
        this.extraData(stringBuilder, stackTraceElementProxy);
        if (n2 > 0) {
            this.printIgnoredCount(stringBuilder, n2);
        }
    }

    private void printIgnoredCount(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(" [").append(n2).append(" skipped]");
    }

    private boolean isIgnoredStackTraceLine(String string) {
        if (this.ignoredStackTraceLines != null) {
            for (String string2 : this.ignoredStackTraceLines) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

