/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator2
implements Abbreviator {
    final int targetLength;

    public TargetLengthBasedClassNameAbbreviator2(int n2) {
        this.targetLength = n2;
    }

    @Override
    public String abbreviate(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.targetLength);
        if (string == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        if (string.length() < this.targetLength) {
            return string;
        }
        int[] nArray = new int[16];
        int[] nArray2 = new int[17];
        int n2 = TargetLengthBasedClassNameAbbreviator2.computeDotIndexes(string, nArray);
        if (n2 == 0) {
            return string;
        }
        this.computeLengthArray(string, nArray, nArray2, n2);
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 == 0) {
                stringBuilder.append(string.substring(0, nArray2[i2] - 1));
                continue;
            }
            stringBuilder.append(string.substring(nArray[i2 - 1], nArray[i2 - 1] + nArray2[i2]));
        }
        return stringBuilder.toString();
    }

    static int computeDotIndexes(String string, int[] nArray) {
        int n2;
        int n3 = 0;
        for (n2 = 0; (n3 = string.indexOf(46, n3)) != -1 && n2 < 16; ++n2) {
            nArray[n2] = n3++;
        }
        return n2;
    }

    void computeLengthArray(String string, int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4 = string.length() - this.targetLength;
        for (n3 = 0; n3 < n2; ++n3) {
            int n5 = n3 == 0 ? -1 : nArray[n3 - 1];
            int n6 = nArray[n3] - n5 - 1;
            n5 = n4 > 0 ? (n6 <= 0 ? n6 : 1) : n6;
            n4 -= n6 - n5;
            nArray2[n3] = n5 + 1;
        }
        n3 = n2 - 1;
        nArray2[n2] = string.length() - nArray[n3];
    }

    static void printArray(String string, int[] nArray) {
        System.out.print(string);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 == 0) {
                System.out.print(nArray[i2]);
                continue;
            }
            System.out.print(", " + nArray[i2]);
        }
        System.out.println();
    }
}

