/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class MDCConverter
extends ClassicConverter {
    private String key;
    private String defaultValue = "";

    @Override
    public void start() {
        String[] stringArray = OptionHelper.extractDefaultReplacement(this.getFirstOption());
        this.key = stringArray[0];
        if (stringArray[1] != null) {
            this.defaultValue = stringArray[1];
        }
        super.start();
    }

    @Override
    public void stop() {
        this.key = null;
        super.stop();
    }

    @Override
    public String convert(ILoggingEvent object) {
        if ((object = object.getMDCPropertyMap()) == null) {
            return this.defaultValue;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys((Map<String, String>)object);
        }
        if ((object = (String)object.get(this.key)) != null) {
            return object;
        }
        return this.defaultValue;
    }

    private String outputMDCForAllKeys(Map<String, String> object) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Map.Entry entry : object.entrySet()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return stringBuilder.toString();
    }

    public String getKey() {
        return this.key;
    }
}

