/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggerComparator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;

public class LoggerContext
extends ContextBase
implements LifeCycle,
ILoggerFactory {
    public static final boolean DEFAULT_PACKAGING_DATA = false;
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private final List<LoggerContextListener> loggerContextListenerList = new ArrayList<LoggerContextListener>();
    private Map<String, Logger> loggerCache;
    private LoggerContextVO loggerContextRemoteView;
    private final TurboFilterList turboFilterList = new TurboFilterList();
    private boolean packagingDataEnabled = false;
    SequenceNumberGenerator sequenceNumberGenerator = null;
    private int maxCallerDataDepth = 8;
    int resetCount = 0;
    private List<String> frameworkPackages;

    public LoggerContext() {
        this.loggerCache = new ConcurrentHashMap<String, Logger>();
        this.loggerContextRemoteView = new LoggerContextVO(this);
        this.root = new Logger("ROOT", null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put("ROOT", this.root);
        this.initEvaluatorMap();
        this.size = 1;
        this.frameworkPackages = new ArrayList<String>();
    }

    void initEvaluatorMap() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    private void updateLoggerContextVO() {
        this.loggerContextRemoteView = new LoggerContextVO(this);
    }

    @Override
    public void putProperty(String string, String string2) {
        super.putProperty(string, string2);
        this.updateLoggerContextVO();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.updateLoggerContextVO();
    }

    public final Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    @Override
    public Logger getLogger(String string) {
        int n2;
        if (string == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if ("ROOT".equalsIgnoreCase(string)) {
            return this.root;
        }
        int n3 = 0;
        Logger logger = this.root;
        Logger logger2 = this.loggerCache.get(string);
        if (logger2 != null) {
            return logger2;
        }
        do {
            String string2 = (n2 = LoggerNameUtil.getSeparatorIndexOf(string, n3)) == -1 ? string : string.substring(0, n2);
            n3 = n2 + 1;
            Logger logger3 = logger;
            synchronized (logger3) {
                logger2 = logger.getChildByName(string2);
                if (logger2 == null) {
                    logger2 = logger.createChildByName(string2);
                    this.loggerCache.put(string2, logger2);
                    this.incSize();
                }
            }
            logger = logger2;
        } while (n2 != -1);
        return logger2;
    }

    private void incSize() {
        ++this.size;
    }

    int size() {
        return this.size;
    }

    public Logger exists(String string) {
        return this.loggerCache.get(string);
    }

    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            this.getStatusManager().add(new WarnStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", logger));
        }
    }

    public List<Logger> getLoggerList() {
        Collection<Logger> collection = this.loggerCache.values();
        collection = new ArrayList<Logger>(collection);
        Collections.sort(collection, new LoggerComparator());
        return collection;
    }

    public LoggerContextVO getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }

    public void setPackagingDataEnabled(boolean bl2) {
        this.packagingDataEnabled = bl2;
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    private void cancelScheduledTasks() {
        Iterator iterator = this.scheduledFutures.iterator();
        while (iterator.hasNext()) {
            ((ScheduledFuture)iterator.next()).cancel(false);
        }
        this.scheduledFutures.clear();
    }

    private void resetStatusListeners() {
        StatusManager statusManager = this.getStatusManager();
        for (StatusListener statusListener : statusManager.getCopyOfStatusListenerList()) {
            statusManager.remove(statusListener);
        }
    }

    public TurboFilterList getTurboFilterList() {
        return this.turboFilterList;
    }

    public void addTurboFilter(TurboFilter turboFilter) {
        this.turboFilterList.add(turboFilter);
    }

    public void resetTurboFilterList() {
        Iterator iterator = this.turboFilterList.iterator();
        while (iterator.hasNext()) {
            ((TurboFilter)iterator.next()).stop();
        }
        this.turboFilterList.clear();
    }

    final FilterReply getTurboFilterChainDecision_0_3OrMore(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, string, objectArray, throwable);
    }

    final FilterReply getTurboFilterChainDecision_1(Marker marker, Logger logger, Level level, String string, Object object, Throwable throwable) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, string, new Object[]{object}, throwable);
    }

    final FilterReply getTurboFilterChainDecision_2(Marker marker, Logger logger, Level level, String string, Object object, Object object2, Throwable throwable) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, string, new Object[]{object, object2}, throwable);
    }

    public void addListener(LoggerContextListener loggerContextListener) {
        this.loggerContextListenerList.add(loggerContextListener);
    }

    public void removeListener(LoggerContextListener loggerContextListener) {
        this.loggerContextListenerList.remove(loggerContextListener);
    }

    private void resetListenersExceptResetResistant() {
        ArrayList<LoggerContextListener> arrayList = new ArrayList<LoggerContextListener>();
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            if (!loggerContextListener.isResetResistant()) continue;
            arrayList.add(loggerContextListener);
        }
        this.loggerContextListenerList.retainAll(arrayList);
    }

    private void resetAllListeners() {
        this.loggerContextListenerList.clear();
    }

    public List<LoggerContextListener> getCopyOfListenerList() {
        return new ArrayList<LoggerContextListener>(this.loggerContextListenerList);
    }

    void fireOnLevelChange(Logger logger, Level level) {
        Iterator<LoggerContextListener> iterator = this.loggerContextListenerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onLevelChange(logger, level);
        }
    }

    private void fireOnReset() {
        Iterator<LoggerContextListener> iterator = this.loggerContextListenerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onReset(this);
        }
    }

    private void fireOnStart() {
        Iterator<LoggerContextListener> iterator = this.loggerContextListenerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart(this);
        }
    }

    private void fireOnStop() {
        Iterator<LoggerContextListener> iterator = this.loggerContextListenerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop(this);
        }
    }

    @Override
    public void start() {
        super.start();
        this.fireOnStart();
    }

    @Override
    public void stop() {
        ((ContextBase)this).reset();
        this.fireOnStop();
        this.resetAllListeners();
        super.stop();
    }

    @Override
    public void reset() {
        ++this.resetCount;
        super.reset();
        this.initEvaluatorMap();
        this.initCollisionMaps();
        this.root.recursiveReset();
        this.resetTurboFilterList();
        this.cancelScheduledTasks();
        this.fireOnReset();
        this.resetListenersExceptResetResistant();
        this.resetStatusListeners();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    public void setMaxCallerDataDepth(int n2) {
        this.maxCallerDataDepth = n2;
    }

    public List<String> getFrameworkPackages() {
        return this.frameworkPackages;
    }

    @Override
    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return null;
    }
}

