/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function$PostCallRead;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function$PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    public StringArray(String[] stringArray) {
        this(stringArray, false);
    }

    public StringArray(String[] stringArray, boolean bl2) {
        this((Object[])stringArray, bl2 ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] stringArray, String string) {
        this((Object[])stringArray, string);
    }

    public StringArray(WString[] wStringArray) {
        this(wStringArray, "--WIDE-STRING--");
    }

    private StringArray(Object[] objectArray, String string) {
        super((objectArray.length + 1) * Native.POINTER_SIZE);
        this.original = objectArray;
        this.encoding = string;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = null;
            if (objectArray[i2] != null) {
                object = new NativeString(objectArray[i2].toString(), string);
                this.natives.add((NativeString)object);
                object = ((NativeString)object).getPointer();
            }
            ((Pointer)this).setPointer(Native.POINTER_SIZE * i2, (Pointer)object);
        }
        ((Pointer)this).setPointer(Native.POINTER_SIZE * objectArray.length, null);
    }

    @Override
    public void read() {
        boolean bl2 = this.original instanceof WString[];
        boolean bl3 = "--WIDE-STRING--".equals(this.encoding);
        for (int i2 = 0; i2 < this.original.length; ++i2) {
            Pointer pointer = ((Pointer)this).getPointer(i2 * Native.POINTER_SIZE);
            CharSequence charSequence = null;
            if (pointer != null) {
                String string = charSequence = bl3 ? pointer.getWideString(0L) : pointer.getString(0L, this.encoding);
                if (bl2) {
                    charSequence = new WString((String)charSequence);
                }
            }
            this.original[i2] = charSequence;
        }
    }

    @Override
    public String toString() {
        String string = "--WIDE-STRING--".equals(this.encoding) ? "const wchar_t*[]" : "const char*[]";
        return string + Arrays.asList(this.original);
    }
}

