/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.ELFAnalyser$ArmAeabiAttributesTag;
import com.sun.jna.ELFAnalyser$ELFSectionHeaderEntry;
import com.sun.jna.ELFAnalyser$ELFSectionHeaders;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ELFAnalyser {
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    private static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    private static final int EI_DATA_BIG_ENDIAN = 2;
    private static final int E_MACHINE_ARM = 40;
    private static final int EI_CLASS_64BIT = 2;
    private final String filename;
    private boolean ELF = false;
    private boolean _64Bit = false;
    private boolean bigEndian = false;
    private boolean armHardFloatFlag = false;
    private boolean armSoftFloatFlag = false;
    private boolean armEabiAapcsVfp = false;
    private boolean arm = false;

    public static ELFAnalyser analyse(String object) throws IOException {
        object = new ELFAnalyser((String)object);
        ((ELFAnalyser)object).runDetection();
        return object;
    }

    public boolean isELF() {
        return this.ELF;
    }

    public boolean is64Bit() {
        return this._64Bit;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isArmHardFloat() {
        return this.isArmEabiAapcsVfp() || this.isArmHardFloatFlag();
    }

    public boolean isArmEabiAapcsVfp() {
        return this.armEabiAapcsVfp;
    }

    public boolean isArmHardFloatFlag() {
        return this.armHardFloatFlag;
    }

    public boolean isArmSoftFloatFlag() {
        return this.armSoftFloatFlag;
    }

    public boolean isArm() {
        return this.arm;
    }

    private ELFAnalyser(String string) {
        this.filename = string;
    }

    private void runDetection() throws IOException {
        RandomAccessFile randomAccessFile;
        block12: {
            block11: {
                randomAccessFile = new RandomAccessFile(this.filename, "r");
                try {
                    if (randomAccessFile.length() > 4L) {
                        byte[] byArray = new byte[4];
                        randomAccessFile.seek(0L);
                        randomAccessFile.read(byArray);
                        if (Arrays.equals(byArray, ELF_MAGIC)) {
                            this.ELF = true;
                        }
                    }
                    if (this.ELF) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
            randomAccessFile.seek(4L);
            byte by2 = randomAccessFile.readByte();
            int n2 = randomAccessFile.readByte();
            this._64Bit = by2 == 2;
            this.bigEndian = n2 == 2;
            randomAccessFile.seek(0L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this._64Bit ? 64 : 52);
            randomAccessFile.getChannel().read(byteBuffer, 0L);
            byteBuffer.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            boolean bl2 = this.arm = byteBuffer.get(18) == 40;
            if (!this.arm) break block12;
            n2 = byteBuffer.getInt(this._64Bit ? 48 : 36);
            this.armHardFloatFlag = (n2 & 0x400) == 1024;
            this.armSoftFloatFlag = (n2 & 0x200) == 512;
            this.parseEabiAapcsVfp(byteBuffer, randomAccessFile);
        }
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parseEabiAapcsVfp(ByteBuffer object, RandomAccessFile randomAccessFile) throws IOException {
        for (ELFAnalyser$ELFSectionHeaderEntry eLFAnalyser$ELFSectionHeaderEntry : new ELFAnalyser$ELFSectionHeaders(this._64Bit, this.bigEndian, (ByteBuffer)((Object)object), randomAccessFile).getEntries()) {
            if (!".ARM.attributes".equals(eLFAnalyser$ELFSectionHeaderEntry.getName())) continue;
            ByteBuffer byteBuffer = ByteBuffer.allocate(eLFAnalyser$ELFSectionHeaderEntry.getSize());
            byteBuffer.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            randomAccessFile.getChannel().read(byteBuffer, eLFAnalyser$ELFSectionHeaderEntry.getOffset());
            byteBuffer.rewind();
            Map<ELFAnalyser$ArmAeabiAttributesTag, Object> map = ELFAnalyser.parseArmAttributes(byteBuffer).get(1);
            if (map == null) continue;
            Object object2 = map.get(ELFAnalyser$ArmAeabiAttributesTag.ABI_VFP_args);
            if (object2 instanceof Integer && ((Integer)object2).equals(1)) {
                this.armEabiAapcsVfp = true;
                continue;
            }
            if (!(object2 instanceof BigInteger) || ((BigInteger)object2).intValue() != 1) continue;
            this.armEabiAapcsVfp = true;
        }
    }

    private static Map<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> parseArmAttributes(ByteBuffer byteBuffer) {
        if (byteBuffer.get() != 65) {
            return Collections.EMPTY_MAP;
        }
        while (byteBuffer.position() < byteBuffer.limit()) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.getInt();
            if (n3 <= 0) break;
            String string = ELFAnalyser.readNTBS(byteBuffer, null);
            if ("aeabi".equals(string)) {
                return ELFAnalyser.parseAEABI(byteBuffer);
            }
            ((Buffer)byteBuffer).position(n2 + n3);
        }
        return Collections.EMPTY_MAP;
    }

    private static Map<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> parseAEABI(ByteBuffer byteBuffer) {
        HashMap<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>> hashMap = new HashMap<Integer, Map<ELFAnalyser$ArmAeabiAttributesTag, Object>>();
        while (byteBuffer.position() < byteBuffer.limit()) {
            int n2 = byteBuffer.position();
            int n3 = ELFAnalyser.readULEB128(byteBuffer).intValue();
            int n4 = byteBuffer.getInt();
            if (n3 == 1) {
                hashMap.put(n3, ELFAnalyser.parseFileAttribute(byteBuffer));
            }
            ((Buffer)byteBuffer).position(n2 + n4);
        }
        return hashMap;
    }

    private static Map<ELFAnalyser$ArmAeabiAttributesTag, Object> parseFileAttribute(ByteBuffer byteBuffer) {
        HashMap<ELFAnalyser$ArmAeabiAttributesTag, Object> hashMap = new HashMap<ELFAnalyser$ArmAeabiAttributesTag, Object>();
        while (byteBuffer.position() < byteBuffer.limit()) {
            ELFAnalyser$ArmAeabiAttributesTag eLFAnalyser$ArmAeabiAttributesTag = ELFAnalyser$ArmAeabiAttributesTag.getByValue(ELFAnalyser.readULEB128(byteBuffer).intValue());
            switch (eLFAnalyser$ArmAeabiAttributesTag.getParameterType()) {
                case UINT32: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, byteBuffer.getInt());
                    break;
                }
                case NTBS: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, ELFAnalyser.readNTBS(byteBuffer, null));
                    break;
                }
                case ULEB128: {
                    hashMap.put(eLFAnalyser$ArmAeabiAttributesTag, ELFAnalyser.readULEB128(byteBuffer));
                }
            }
        }
        return hashMap;
    }

    private static String readNTBS(ByteBuffer byteBuffer, Integer n2) {
        if (n2 != null) {
            ((Buffer)byteBuffer).position(n2);
        }
        int n3 = byteBuffer.position();
        while (byteBuffer.get() != 0 && byteBuffer.position() <= byteBuffer.limit()) {
        }
        byte[] byArray = new byte[byteBuffer.position() - n3 - 1];
        ((Buffer)byteBuffer).position(n3);
        byteBuffer.get(byArray);
        ByteBuffer byteBuffer2 = byteBuffer;
        ((Buffer)byteBuffer2).position(byteBuffer2.position() + 1);
        try {
            return new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static BigInteger readULEB128(ByteBuffer byteBuffer) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (true) {
            byte by2 = byteBuffer.get();
            bigInteger = bigInteger.or(BigInteger.valueOf(by2 & 0x7F).shiftLeft(n2));
            if ((by2 & 0x80) == 0) break;
            n2 += 7;
        }
        return bigInteger;
    }
}

