/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FileUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public FileUtil(Context context) {
        this.setContext(context);
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected exception on file [" + file + "]", malformedURLException);
        }
    }

    public static boolean createMissingParentDirectories(File file) {
        if ((file = file.getParentFile()) == null) {
            return true;
        }
        file.mkdirs();
        return file.exists();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String resourceAsString(ClassLoader object, String string) {
        int n2;
        if ((object = ((ClassLoader)object).getResource(string)) == null) {
            this.addError("Failed to find resource [" + string + "]");
            return null;
        }
        InputStreamReader inputStreamReader = null;
        object = ((URL)object).openConnection();
        ((URLConnection)object).setUseCaches(false);
        inputStreamReader = new InputStreamReader(((URLConnection)object).getInputStream());
        object = new char[128];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n2 = inputStreamReader.read((char[])object, 0, ((Object)object).length)) != -1) {
            stringBuilder.append((char[])object, 0, n2);
        }
        object = stringBuilder.toString();
        try {
            inputStreamReader.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
        catch (IOException iOException) {
            try {
                this.addError("Failed to open ".concat(String.valueOf(string)), iOException);
                if (inputStreamReader == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStreamReader == null) throw throwable;
                try {
                    inputStreamReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                inputStreamReader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    public void copy(String string, String string2) throws RolloverFailure {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                int n2;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                byte[] byArray = new byte[32768];
                while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                }
                bufferedInputStream.close();
                bufferedInputStream = null;
                filterOutputStream.close();
                filterOutputStream = null;
                return;
            }
            catch (IOException iOException) {
                String string3 = "Failed to copy [" + string + "] to [" + string2 + "]";
                this.addError(string3, iOException);
                throw new RolloverFailure(string3);
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }
}

