/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class StatusBase
implements Status {
    private static final List<Status> EMPTY_LIST = new ArrayList<Status>(0);
    int level;
    final String message;
    final Object origin;
    List<Status> childrenList;
    Throwable throwable;
    long date;

    StatusBase(int n2, String string, Object object) {
        this(n2, string, object, null);
    }

    StatusBase(int n2, String string, Object object, Throwable throwable) {
        this.level = n2;
        this.message = string;
        this.origin = object;
        this.throwable = throwable;
        this.date = System.currentTimeMillis();
    }

    @Override
    public synchronized void add(Status status) {
        if (status == null) {
            throw new NullPointerException("Null values are not valid Status.");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Status>();
        }
        this.childrenList.add(status);
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.childrenList != null && this.childrenList.size() > 0;
    }

    @Override
    public synchronized Iterator<Status> iterator() {
        if (this.childrenList != null) {
            return this.childrenList.iterator();
        }
        return EMPTY_LIST.iterator();
    }

    @Override
    public synchronized boolean remove(Status status) {
        if (this.childrenList == null) {
            return false;
        }
        return this.childrenList.remove(status);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public synchronized int getEffectiveLevel() {
        int n2 = this.level;
        Iterator<Status> iterator = this.iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.next().getEffectiveLevel();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public Long getDate() {
        return this.date;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getEffectiveLevel()) {
            case 0: {
                stringBuilder.append("INFO");
                break;
            }
            case 1: {
                stringBuilder.append("WARN");
                break;
            }
            case 2: {
                stringBuilder.append("ERROR");
            }
        }
        if (this.origin != null) {
            stringBuilder.append(" in ");
            stringBuilder.append(this.origin);
            stringBuilder.append(" -");
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.message);
        if (this.throwable != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.throwable);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31 + this.level;
        return 31 * n2 + (this.message == null ? 0 : this.message.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (StatusBase)object;
        if (this.level != ((StatusBase)object).level) {
            return false;
        }
        return !(this.message == null ? ((StatusBase)object).message != null : !this.message.equals(((StatusBase)object).message));
    }
}

