/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class RollingFileAppender<E>
extends FileAppender<E> {
    File currentlyActiveFile;
    TriggeringPolicy<E> triggeringPolicy;
    RollingPolicy rollingPolicy;
    private static String RFA_NO_TP_URL = "http://logback.qos.ch/codes.html#rfa_no_tp";
    private static String RFA_NO_RP_URL = "http://logback.qos.ch/codes.html#rfa_no_rp";
    private static String COLLISION_URL = "http://logback.qos.ch/codes.html#rfa_collision";
    private static String RFA_LATE_FILE_URL = "http://logback.qos.ch/codes.html#rfa_file_after";

    @Override
    public void start() {
        if (this.triggeringPolicy == null) {
            this.addWarn("No TriggeringPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit " + RFA_NO_TP_URL);
            return;
        }
        if (!this.triggeringPolicy.isStarted()) {
            this.addWarn("TriggeringPolicy has not started. RollingFileAppender will not start");
            return;
        }
        if (this.checkForCollisionsInPreviousRollingFileAppenders()) {
            this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
            this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
            return;
        }
        if (!this.append) {
            this.addWarn("Append mode is mandatory for RollingFileAppender. Defaulting to append=true.");
            this.append = true;
        }
        if (this.rollingPolicy == null) {
            this.addError("No RollingPolicy was set for the RollingFileAppender named " + this.getName());
            this.addError("For more information, please visit " + RFA_NO_RP_URL);
            return;
        }
        if (this.checkForFileAndPatternCollisions()) {
            this.addError("File property collides with fileNamePattern. Aborting.");
            this.addError("For more information, please visit " + COLLISION_URL);
            return;
        }
        if (this.isPrudent()) {
            if (this.rawFileProperty() != null) {
                this.addWarn("Setting \"File\" property to null on account of prudent mode");
                ((FileAppender)this).setFile(null);
            }
            if (this.rollingPolicy.getCompressionMode() != CompressionMode.NONE) {
                this.addError("Compression is not supported in prudent mode. Aborting");
                return;
            }
        }
        this.currentlyActiveFile = new File(((FileAppender)this).getFile());
        this.addInfo("Active log file name: " + ((FileAppender)this).getFile());
        super.start();
    }

    private boolean checkForFileAndPatternCollisions() {
        Object object;
        if (this.triggeringPolicy instanceof RollingPolicyBase && (object = ((RollingPolicyBase)((Object)this.triggeringPolicy)).fileNamePattern) != null && this.fileName != null) {
            object = ((FileNamePattern)object).toRegex();
            return this.fileName.matches((String)object);
        }
        return false;
    }

    private boolean checkForCollisionsInPreviousRollingFileAppenders() {
        FileNamePattern fileNamePattern;
        boolean bl2 = false;
        if (this.triggeringPolicy instanceof RollingPolicyBase && this.innerCheckForFileNamePatternCollisionInPreviousRFA(fileNamePattern = ((RollingPolicyBase)((Object)this.triggeringPolicy)).fileNamePattern)) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean innerCheckForFileNamePatternCollisionInPreviousRFA(FileNamePattern fileNamePattern) {
        boolean bl2 = false;
        Map map = (Map)this.context.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
        if (map == null) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!fileNamePattern.equals(entry.getValue())) continue;
            this.addErrorForCollision("FileNamePattern", ((FileNamePattern)entry.getValue()).toString(), (String)entry.getKey());
            bl2 = true;
        }
        if (this.name != null) {
            map.put(this.getName(), fileNamePattern);
        }
        return bl2;
    }

    @Override
    public void stop() {
        Map<String, FileNamePattern> map;
        super.stop();
        if (this.rollingPolicy != null) {
            this.rollingPolicy.stop();
        }
        if (this.triggeringPolicy != null) {
            this.triggeringPolicy.stop();
        }
        if ((map = ContextUtil.getFilenamePatternCollisionMap(this.context)) != null && this.getName() != null) {
            map.remove(this.getName());
        }
    }

    @Override
    public void setFile(String string) {
        if (string != null && (this.triggeringPolicy != null || this.rollingPolicy != null)) {
            this.addError("File property must be set before any triggeringPolicy or rollingPolicy properties");
            this.addError("For more information, please visit " + RFA_LATE_FILE_URL);
        }
        super.setFile(string);
    }

    @Override
    public String getFile() {
        return this.rollingPolicy.getActiveFileName();
    }

    public void rollover() {
        this.lock.lock();
        try {
            this.closeOutputStream();
            this.attemptRollover();
            this.attemptOpenFile();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void attemptOpenFile() {
        try {
            this.currentlyActiveFile = new File(this.rollingPolicy.getActiveFileName());
            RollingFileAppender rollingFileAppender = this;
            rollingFileAppender.openFile(rollingFileAppender.rollingPolicy.getActiveFileName());
            return;
        }
        catch (IOException iOException) {
            this.addError("setFile(" + this.fileName + ", false) call failed.", iOException);
            return;
        }
    }

    private void attemptRollover() {
        try {
            this.rollingPolicy.rollover();
            return;
        }
        catch (RolloverFailure rolloverFailure) {
            this.addWarn("RolloverFailure occurred. Deferring roll-over.");
            this.append = true;
            return;
        }
    }

    @Override
    public void subAppend(E e2) {
        TriggeringPolicy<E> triggeringPolicy = this.triggeringPolicy;
        synchronized (triggeringPolicy) {
            if (this.triggeringPolicy.isTriggeringEvent(this.currentlyActiveFile, e2)) {
                this.rollover();
            }
        }
        super.subAppend(e2);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy<E> getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy rollingPolicy) {
        this.rollingPolicy = rollingPolicy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)rollingPolicy);
        }
    }

    public void setTriggeringPolicy(TriggeringPolicy<E> triggeringPolicy) {
        this.triggeringPolicy = triggeringPolicy;
        if (triggeringPolicy instanceof RollingPolicy) {
            this.rollingPolicy = (RollingPolicy)((Object)triggeringPolicy);
        }
    }
}

