/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map<String, String> converterMap;

    Compiler(Node node, Map<String, String> map) {
        this.top = node;
        this.converterMap = map;
    }

    Converter<E> compile() {
        Compiler compiler = this;
        compiler.tail = null;
        compiler.head = null;
        Node node = this.top;
        while (node != null) {
            switch (node.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)node.getValue()));
                    break;
                }
                case 2: {
                    Converter<E> converter = (CompositeNode)node;
                    Converter converter2 = this.createCompositeConverter((CompositeNode)((Object)converter));
                    if (converter2 == null) {
                        this.addError("Failed to create converter for [%" + ((Node)((Object)converter)).getValue() + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + ((Node)((Object)converter)).getValue() + "]"));
                        break;
                    }
                    ((FormattingConverter)converter2).setFormattingInfo(((FormattingNode)((Object)converter)).getFormatInfo());
                    ((DynamicConverter)converter2).setOptionList(((SimpleKeywordNode)((Object)converter)).getOptions());
                    converter = new Compiler<E>(((CompositeNode)((Object)converter)).getChildNode(), this.converterMap);
                    ((ContextAwareBase)((Object)converter)).setContext(this.context);
                    converter = ((Compiler)((Object)converter)).compile();
                    ((CompositeConverter)converter2).setChildConverter(converter);
                    this.addToList(converter2);
                    break;
                }
                case 1: {
                    Converter<E> converter = (SimpleKeywordNode)node;
                    Converter converter2 = this.createConverter((SimpleKeywordNode)((Object)converter));
                    if (converter2 != null) {
                        ((FormattingConverter)converter2).setFormattingInfo(((FormattingNode)((Object)converter)).getFormatInfo());
                        ((DynamicConverter)converter2).setOptionList(((SimpleKeywordNode)((Object)converter)).getOptions());
                        this.addToList(converter2);
                        break;
                    }
                    converter2 = new LiteralConverter("%PARSER_ERROR[" + ((Node)((Object)converter)).getValue() + "]");
                    this.addStatus(new ErrorStatus("[" + ((Node)((Object)converter)).getValue() + "] is not a valid conversion word", this));
                    this.addToList(converter2);
                }
            }
            node = node.next;
        }
        return this.head;
    }

    private void addToList(Converter<E> converter) {
        if (this.head == null) {
            this.tail = converter;
            this.head = this.tail;
            return;
        }
        this.tail.setNext(converter);
        this.tail = converter;
    }

    DynamicConverter<E> createConverter(SimpleKeywordNode object) {
        String string = this.converterMap.get(object = (String)((Node)object).getValue());
        if (string != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(string, DynamicConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string + "] for keyword [" + (String)object + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for conversion word [" + (String)object + "]");
        return null;
    }

    CompositeConverter<E> createCompositeConverter(CompositeNode object) {
        String string = this.converterMap.get(object = (String)((Node)object).getValue());
        if (string != null) {
            try {
                return (CompositeConverter)OptionHelper.instantiateByClassName(string, CompositeConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string + "] as a composite converter for keyword [" + (String)object + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + (String)object + "]");
        return null;
    }
}

