/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.action.ActionUtil$Scope;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.NamedModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyModelHandler
extends ModelHandlerBase {
    public static final String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    public PropertyModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new PropertyModelHandler(context);
    }

    protected Class<PropertyModel> getSupportedModelClass() {
        return PropertyModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) {
        object = (PropertyModel)object;
        ActionUtil$Scope actionUtil$Scope = ActionUtil.stringToScope(((PropertyModel)object).getScopeStr());
        if (this.checkFileAttributeSanity((PropertyModel)object)) {
            String string = ((PropertyModel)object).getFile();
            string = modelInterpretationContext.subst(string);
            try {
                object = new FileInputStream(string);
                this.loadAndSetProperties(modelInterpretationContext, (InputStream)object, actionUtil$Scope);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string + "].");
                return;
            }
            catch (IOException iOException) {
                this.addError("Could not read properties file [" + string + "].", iOException);
                return;
            }
        }
        if (this.checkResourceAttributeSanity((PropertyModel)object)) {
            String string = ((PropertyModel)object).getResource();
            object = Loader.getResourceBySelfClassLoader(string = modelInterpretationContext.subst(string));
            if (object == null) {
                this.addError("Could not find resource [" + string + "].");
                return;
            }
            try {
                object = ((URL)object).openStream();
                this.loadAndSetProperties(modelInterpretationContext, (InputStream)object, actionUtil$Scope);
                return;
            }
            catch (IOException iOException) {
                this.addError("Could not read resource file [" + string + "].", iOException);
                return;
            }
        }
        if (this.checkValueNameAttributesSanity((PropertyModel)object)) {
            String string = RegularEscapeUtil.basicEscape(((PropertyModel)object).getValue()).trim();
            string = modelInterpretationContext.subst(string);
            ActionUtil.setProperty(modelInterpretationContext, ((NamedModel)object).getName(), string, actionUtil$Scope);
            return;
        }
        this.addError(INVALID_ATTRIBUTES);
    }

    void loadAndSetProperties(ModelInterpretationContext modelInterpretationContext, InputStream inputStream, ActionUtil$Scope actionUtil$Scope) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        ModelUtil.setProperties(modelInterpretationContext, properties, actionUtil$Scope);
    }

    boolean checkFileAttributeSanity(PropertyModel object) {
        String string = ((PropertyModel)object).getFile();
        String string2 = ((NamedModel)object).getName();
        String string3 = ((PropertyModel)object).getValue();
        object = ((PropertyModel)object).getResource();
        return !OptionHelper.isNullOrEmpty(string) && OptionHelper.isNullOrEmpty(string2) && OptionHelper.isNullOrEmpty(string3) && OptionHelper.isNullOrEmpty((String)object);
    }

    boolean checkResourceAttributeSanity(PropertyModel propertyModel) {
        String string = propertyModel.getFile();
        String string2 = propertyModel.getName();
        String string3 = propertyModel.getValue();
        return !OptionHelper.isNullOrEmpty(propertyModel.getResource()) && OptionHelper.isNullOrEmpty(string2) && OptionHelper.isNullOrEmpty(string3) && OptionHelper.isNullOrEmpty(string);
    }

    boolean checkValueNameAttributesSanity(PropertyModel object) {
        String string = ((PropertyModel)object).getFile();
        String string2 = ((NamedModel)object).getName();
        String string3 = ((PropertyModel)object).getValue();
        object = ((PropertyModel)object).getResource();
        return !OptionHelper.isNullOrEmpty(string2) && !OptionHelper.isNullOrEmpty(string3) && OptionHelper.isNullOrEmpty(string) && OptionHelper.isNullOrEmpty((String)object);
    }
}

