/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DependencyDefinition;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ModelInterpretationContext
extends ContextAwareBase
implements PropertyContainer {
    Stack<Object> objectStack;
    Stack<Model> modelStack;
    Map<String, Object> objectMap;
    protected Map<String, String> propertiesMap;
    protected Map<String, String> importMap;
    private final BeanDescriptionCache beanDescriptionCache;
    final DefaultNestedComponentRegistry defaultNestedComponentRegistry = new DefaultNestedComponentRegistry();
    List<DependencyDefinition> dependencyDefinitionList = new ArrayList<DependencyDefinition>();
    final List<String> startedDependees = new ArrayList<String>();

    public ModelInterpretationContext(Context context) {
        this.context = context;
        this.objectStack = new Stack();
        this.modelStack = new Stack();
        this.beanDescriptionCache = new BeanDescriptionCache(context);
        this.objectMap = new HashMap<String, Object>(5);
        this.propertiesMap = new HashMap<String, String>(5);
        this.importMap = new HashMap<String, String>(5);
    }

    public ModelInterpretationContext(ModelInterpretationContext modelInterpretationContext) {
        this(modelInterpretationContext.context);
        this.importMap = new HashMap<String, String>(modelInterpretationContext.importMap);
        this.propertiesMap = new HashMap<String, String>(modelInterpretationContext.propertiesMap);
        this.defaultNestedComponentRegistry.duplicate(modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.createAppenderBags();
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void createAppenderBags() {
        this.objectMap.put("APPENDER_BAG", new HashMap());
        this.objectMap.put("APPENDER_REF_BAG", new HashMap());
    }

    public void pushModel(Model model) {
        this.modelStack.push(model);
    }

    public Model peekModel() {
        return this.modelStack.peek();
    }

    public boolean isModelStackEmpty() {
        return this.modelStack.isEmpty();
    }

    public Model popModel() {
        return this.modelStack.pop();
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public boolean isObjectStackEmpty() {
        return this.objectStack.isEmpty();
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object object) {
        this.objectStack.push(object);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int n2) {
        return this.objectStack.get(n2);
    }

    public BeanDescriptionCache getBeanDescriptionCache() {
        return this.beanDescriptionCache;
    }

    public String subst(String string) {
        if (string == null) {
            return null;
        }
        try {
            ModelInterpretationContext modelInterpretationContext = this;
            return OptionHelper.substVars(string, modelInterpretationContext, modelInterpretationContext.context);
        }
        catch (ScanException | IllegalArgumentException exception) {
            this.addError("Problem while parsing [" + string + "]", exception);
            return string;
        }
    }

    public void addSubstitutionProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        string2 = string2.trim();
        this.propertiesMap.put(string, string2);
    }

    public void addSubstitutionProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            this.addSubstitutionProperty(string, string2);
        }
    }

    public DefaultNestedComponentRegistry getDefaultNestedComponentRegistry() {
        return this.defaultNestedComponentRegistry;
    }

    public void addDependencyDefinition(DependencyDefinition dependencyDefinition) {
        this.dependencyDefinitionList.add(dependencyDefinition);
    }

    public List<DependencyDefinition> getDependencyDefinitions() {
        return Collections.unmodifiableList(this.dependencyDefinitionList);
    }

    public List<String> getDependeeNamesForModel(Model model) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DependencyDefinition dependencyDefinition : this.dependencyDefinitionList) {
            if (dependencyDefinition.getDepender() != model) continue;
            arrayList.add(dependencyDefinition.getDependee());
        }
        return arrayList;
    }

    public boolean hasDependers(String string) {
        if (string == null || string.trim().length() == 0) {
            new IllegalArgumentException("Empty dependeeName name not allowed here");
        }
        Iterator<DependencyDefinition> iterator = this.dependencyDefinitionList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().dependee.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void markStartOfNamedDependee(String string) {
        this.startedDependees.add(string);
    }

    public boolean isNamedDependeeStarted(String string) {
        return this.startedDependees.contains(string);
    }

    @Override
    public String getProperty(String string) {
        String string2 = this.propertiesMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return this.context.getProperty(string);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertiesMap);
    }

    public void addImport(String string, String string2) {
        this.importMap.put(string, string2);
    }

    public Map<String, String> getImportMapCopy() {
        return new HashMap<String, String>(this.importMap);
    }

    public String getImport(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.importMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }
}

