/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Model
implements Serializable {
    private static final long serialVersionUID = -797372668713068159L;
    boolean handled = false;
    boolean skipped = false;
    String tag;
    String bodyText;
    int lineNumber;
    List<Model> subModels = new ArrayList<Model>();

    public static Model duplicate(Model object) {
        Model model = ((Model)object).makeNewInstance();
        model.mirror((Model)object);
        object = ((Model)object).subModels.iterator();
        while (object.hasNext()) {
            Model model2 = Model.duplicate((Model)object.next());
            model.subModels.add(model2);
        }
        return model;
    }

    protected Model makeNewInstance() {
        return new Model();
    }

    public void mirror(Model model) {
        this.tag = model.tag;
        this.bodyText = model.bodyText;
        this.lineNumber = model.lineNumber;
    }

    public void markAsSkipped() {
        this.skipped = true;
    }

    void resetForReuse() {
        this.handled = false;
        this.skipped = false;
        Iterator<Model> iterator = this.subModels.iterator();
        while (iterator.hasNext()) {
            iterator.next().resetForReuse();
        }
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isUnhandled() {
        return !this.handled;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void markAsHandled() {
        this.handled = true;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public void addSubModel(Model model) {
        this.subModels.add(model);
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void addText(String string) {
        if (this.bodyText == null) {
            this.bodyText = string;
            return;
        }
        this.bodyText = this.bodyText + string;
    }

    public String idString() {
        return "<" + this.tag + "> at line " + this.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.bodyText, this.lineNumber, this.subModels, this.tag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Model)object;
        return Objects.equals(this.bodyText, ((Model)object).bodyText) && this.lineNumber == ((Model)object).lineNumber && Objects.equals(this.subModels, ((Model)object).subModels) && Objects.equals(this.tag, ((Model)object).tag);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [tag=" + this.tag + ", bodyText=" + this.bodyText + ", id=" + this.hashCode() + "]";
    }
}

