/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.CAI_WithLocatorSupport;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.EventPlayer;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SaxEventInterpreter {
    private static Action NOP_ACTION_SINGLETON = new NOPAction();
    private final RuleStore ruleStore;
    private final SaxEventInterpretationContext interpretationContext;
    private Supplier<Action> implicitActionSupplier;
    private final CAI_WithLocatorSupport cai;
    private ElementPath elementPath;
    Locator locator;
    EventPlayer eventPlayer;
    Context context;
    Stack<Action> actionStack;
    ElementPath skip = null;

    public SaxEventInterpreter(Context context, RuleStore ruleStore, ElementPath elementPath, List<SaxEvent> list) {
        this.context = context;
        this.cai = new CAI_WithLocatorSupport(context, this);
        this.ruleStore = ruleStore;
        this.interpretationContext = new SaxEventInterpretationContext(context, this);
        this.elementPath = elementPath;
        this.actionStack = new Stack();
        this.eventPlayer = new EventPlayer(this, list);
    }

    public EventPlayer getEventPlayer() {
        return this.eventPlayer;
    }

    public ElementPath getCopyOfElementPath() {
        return this.elementPath.duplicate();
    }

    public SaxEventInterpretationContext getSaxEventInterpretationContext() {
        return this.interpretationContext;
    }

    public void startDocument() {
    }

    public void startElement(StartEvent startEvent) {
        this.setDocumentLocator(startEvent.getLocator());
        this.startElement(startEvent.namespaceURI, startEvent.localName, startEvent.qName, startEvent.attributes);
    }

    private void startElement(String string, String object, String string2, Attributes attributes) {
        string = this.getTagName((String)object, string2);
        this.elementPath.push(string);
        if (this.skip != null) {
            this.pushEmptyActionOntoActionStack();
            return;
        }
        SaxEventInterpreter saxEventInterpreter = this;
        object = saxEventInterpreter.getApplicableAction(saxEventInterpreter.elementPath, attributes);
        if (object != null) {
            this.actionStack.add((Action)object);
            this.callBeginAction((Action)object, string, attributes);
            return;
        }
        this.pushEmptyActionOntoActionStack();
        string = "no applicable action for [" + string + "], current ElementPath  is [" + this.elementPath + "]";
        this.cai.addError(string);
    }

    private void pushEmptyActionOntoActionStack() {
        this.actionStack.push(NOP_ACTION_SINGLETON);
    }

    public void characters(BodyEvent object) {
        this.setDocumentLocator(((BodyEvent)object).locator);
        object = ((BodyEvent)object).getText();
        Action action = this.actionStack.peek();
        if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
            this.callBodyAction(action, (String)object);
        }
    }

    public void endElement(EndEvent endEvent) {
        this.setDocumentLocator(endEvent.locator);
        this.endElement(endEvent.namespaceURI, endEvent.localName, endEvent.qName);
    }

    private void endElement(String object, String string, String string2) {
        object = this.actionStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.elementPath)) {
                this.skip = null;
            }
        } else if (object != NOP_ACTION_SINGLETON) {
            this.callEndAction((Action)object, this.getTagName(string, string2));
        }
        this.elementPath.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    String getTagName(String string, String string2) {
        if (string == null || string.length() <= 0) {
            string = string2;
        }
        return string;
    }

    public void setImplicitActionSupplier(Supplier<Action> supplier) {
        this.implicitActionSupplier = supplier;
    }

    Action getApplicableAction(ElementPath object, Attributes attributes) {
        if ((object = this.ruleStore.matchActions((ElementPath)object)) != null) {
            object = (Action)object.get();
            ((ContextAwareBase)object).setContext(this.context);
            return object;
        }
        object = this.implicitActionSupplier.get();
        ((ContextAwareBase)object).setContext(this.context);
        return object;
    }

    void callBeginAction(Action action, String string, Attributes attributes) {
        if (action == null) {
            return;
        }
        try {
            action.begin(this.interpretationContext, string, attributes);
            return;
        }
        catch (ActionException actionException) {
            this.skip = this.elementPath.duplicate();
            this.cai.addError("ActionException in Action for tag [" + string + "]", actionException);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.skip = this.elementPath.duplicate();
            this.cai.addError("RuntimeException in Action for tag [" + string + "]", runtimeException);
            return;
        }
    }

    private void callBodyAction(Action action, String string) {
        if (action == null) {
            return;
        }
        try {
            action.body(this.interpretationContext, string);
            return;
        }
        catch (ActionException actionException) {
            this.cai.addError("Exception in body() method for action [" + action + "]", actionException);
            return;
        }
    }

    private void callEndAction(Action action, String string) {
        if (action == null) {
            return;
        }
        try {
            action.end(this.interpretationContext, string);
            return;
        }
        catch (ActionException actionException) {
            this.cai.addError("ActionException in Action for tag [" + string + "]", actionException);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.cai.addError("RuntimeException in Action for tag [" + string + "]", runtimeException);
            return;
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }
}

