/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.html;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.html.CssBuilder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class HTMLLayoutBase<E>
extends LayoutBase<E> {
    protected String pattern;
    protected Converter<E> head;
    protected String title = "Logback Log Messages";
    protected CssBuilder cssBuilder;
    protected long counter = 0L;

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public CssBuilder getCssBuilder() {
        return this.cssBuilder;
    }

    public void setCssBuilder(CssBuilder cssBuilder) {
        this.cssBuilder = cssBuilder;
    }

    @Override
    public void start() {
        int n2 = 0;
        try {
            Parser parser = new Parser(this.pattern);
            parser.setContext(((ContextAwareBase)this).getContext());
            Node node = parser.parse();
            this.head = parser.compile(node, this.getEffectiveConverterMap());
            ConverterUtil.startConverters(this.head);
        }
        catch (ScanException scanException) {
            this.addError("Incorrect pattern found", scanException);
            ++n2;
        }
        if (n2 == 0) {
            this.started = true;
        }
    }

    protected abstract Map<String, String> getDefaultConverterMap();

    public Map<String, String> getEffectiveConverterMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = this.getDefaultConverterMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        if ((map = ((ContextAwareBase)this).getContext()) != null && (map = (Map)map.getObject("PATTERN_RULE_REGISTRY")) != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public String getFileHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
        stringBuilder.append(" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<html>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("  <head>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("    <title>");
        stringBuilder.append(this.title);
        stringBuilder.append("</title>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        this.cssBuilder.addCss(stringBuilder);
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("  </head>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<body>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    @Override
    public String getPresentationHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<hr/>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<p>Log session start time ");
        stringBuilder.append(new Date());
        stringBuilder.append("</p><p></p>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<table cellspacing=\"0\">");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        this.buildHeaderRowForTable(stringBuilder);
        return stringBuilder.toString();
    }

    private void buildHeaderRowForTable(StringBuilder stringBuilder) {
        Converter<E> converter = this.head;
        stringBuilder.append("<tr class=\"header\">");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        while (converter != null) {
            if (this.computeConverterName(converter) == null) {
                converter = converter.getNext();
                continue;
            }
            stringBuilder.append("<td class=\"");
            stringBuilder.append(this.computeConverterName(converter));
            stringBuilder.append("\">");
            stringBuilder.append(this.computeConverterName(converter));
            stringBuilder.append("</td>");
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            converter = converter.getNext();
        }
        stringBuilder.append("</tr>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }

    @Override
    public String getPresentationFooter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    @Override
    public String getFileFooter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    protected void startNewTableIfLimitReached(StringBuilder stringBuilder) {
        if (this.counter >= 10000L) {
            this.counter = 0L;
            stringBuilder.append("</table>");
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            stringBuilder.append("<p></p>");
            stringBuilder.append("<table cellspacing=\"0\">");
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            this.buildHeaderRowForTable(stringBuilder);
        }
    }

    public String computeConverterName(Converter<E> object) {
        int n2 = ((String)(object = object.getClass().getSimpleName())).indexOf("Converter");
        if (n2 == -1) {
            return object;
        }
        return ((String)object).substring(0, n2);
    }
}

