/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class LogbackMDCAdapter
implements MDCAdapter {
    final ThreadLocal<Map<String, String>> copyOnThreadLocal = new ThreadLocal();
    private static final int WRITE_OPERATION = 1;
    private static final int MAP_COPY_OPERATION = 2;
    final ThreadLocal<Integer> lastOperation = new ThreadLocal();
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    private Integer getAndSetLastOperation(int n2) {
        Integer n3 = this.lastOperation.get();
        this.lastOperation.set(n2);
        return n3;
    }

    private boolean wasLastOpReadOrNull(Integer n2) {
        return n2 == null || n2 == 2;
    }

    private Map<String, String> duplicateAndInsertNewMap(Map<String, String> map) {
        Map<String, String> map2 = Collections.synchronizedMap(new HashMap());
        if (map != null) {
            Map<String, String> map3 = map;
            synchronized (map3) {
                map2.putAll(map);
            }
        }
        this.copyOnThreadLocal.set(map2);
        return map2;
    }

    @Override
    public void put(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = this.copyOnThreadLocal.get();
        Integer n2 = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(n2) || map == null) {
            this.duplicateAndInsertNewMap(map).put(string, string2);
            return;
        }
        map.put(string, string2);
    }

    @Override
    public void remove(String string) {
        if (string == null) {
            return;
        }
        Map<String, String> map = this.copyOnThreadLocal.get();
        if (map == null) {
            return;
        }
        Integer n2 = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(n2)) {
            this.duplicateAndInsertNewMap(map).remove(string);
            return;
        }
        map.remove(string);
    }

    @Override
    public void clear() {
        this.lastOperation.set(1);
        this.copyOnThreadLocal.remove();
    }

    @Override
    public String get(String string) {
        Map<String, String> map = this.copyOnThreadLocal.get();
        if (map != null && string != null) {
            return map.get(string);
        }
        return null;
    }

    public Map<String, String> getPropertyMap() {
        this.lastOperation.set(2);
        return this.copyOnThreadLocal.get();
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    @Override
    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> map = this.copyOnThreadLocal.get();
        if (map == null) {
            return null;
        }
        return new HashMap<String, String>(map);
    }

    @Override
    public void setContextMap(Map<String, String> map) {
        this.lastOperation.set(1);
        Map<String, String> map2 = Collections.synchronizedMap(new HashMap());
        map2.putAll(map);
        this.copyOnThreadLocal.set(map2);
    }

    @Override
    public void pushByKey(String string, String string2) {
        this.threadLocalMapOfDeques.pushByKey(string, string2);
    }

    @Override
    public String popByKey(String string) {
        return this.threadLocalMapOfDeques.popByKey(string);
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String string) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(string);
    }

    @Override
    public void clearDequeByKey(String string) {
        this.threadLocalMapOfDeques.clearDequeByKey(string);
    }
}

