/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL uRL) throws JoranException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        if (uRL.toString().endsWith("xml")) {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext(this.loggerContext);
            joranConfigurator.doConfigure(uRL);
            return;
        }
        throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be .xml");
    }

    void joranConfigureByResource(URL uRL) throws JoranException {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.loggerContext);
        joranConfigurator.doConfigure(uRL);
    }

    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean bl2) {
        String string = OptionHelper.getSystemProperty(CONFIG_FILE_PROPERTY);
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource(string, classLoader);
                if (uRL != null) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
                Serializable serializable = new File(string);
                if (serializable.exists() && serializable.isFile()) {
                    try {
                        uRL = serializable.toURI().toURL();
                        serializable = uRL;
                        return serializable;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                if (bl2) {
                    this.statusOnResourceSearch(string, classLoader, uRL);
                }
            }
        }
        return null;
    }

    public URL findURLOfDefaultConfigurationFile(boolean bl2) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
        URL uRL = this.findConfigFileURLFromSystemProperties(classLoader, bl2);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(TEST_AUTOCONFIG_FILE, classLoader, bl2);
        if (uRL != null) {
            return uRL;
        }
        return this.getResource(AUTOCONFIG_FILE, classLoader, bl2);
    }

    private URL getResource(String string, ClassLoader classLoader, boolean bl2) {
        URL uRL = Loader.getResource(string, classLoader);
        if (bl2) {
            this.statusOnResourceSearch(string, classLoader, uRL);
        }
        return uRL;
    }

    public void autoConfig() throws JoranException {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        Object object = this.findURLOfDefaultConfigurationFile(true);
        if (object != null) {
            this.configureByResource((URL)object);
            return;
        }
        object = ClassicEnvUtil.loadFromServiceLoader(Configurator.class);
        if (object != null) {
            try {
                object.setContext(this.loggerContext);
                object.configure(this.loggerContext);
                return;
            }
            catch (Exception exception) {
                throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", object != null ? object.getClass().getCanonicalName() : "null"), exception);
            }
        }
        BasicConfigurator basicConfigurator = new BasicConfigurator();
        basicConfigurator.setContext(this.loggerContext);
        basicConfigurator.configure(this.loggerContext);
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, URL uRL) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        if (uRL == null) {
            statusManager.add(new InfoStatus("Could NOT find resource [" + string + "]", this.loggerContext));
            return;
        }
        statusManager.add(new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", this.loggerContext));
        this.multiplicityWarning(string, classLoader);
    }

    private void multiplicityWarning(String string, ClassLoader object) {
        Object object2 = null;
        StatusManager statusManager = this.loggerContext.getStatusManager();
        try {
            object2 = Loader.getResources(string, (ClassLoader)object);
        }
        catch (IOException iOException) {
            statusManager.add(new ErrorStatus("Failed to get url list for resource [" + string + "]", this.loggerContext, iOException));
        }
        if (object2 != null && object2.size() > 1) {
            statusManager.add(new WarnStatus("Resource [" + string + "] occurs multiple times on the classpath.", this.loggerContext));
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (URL)object.next();
                statusManager.add(new WarnStatus("Resource [" + string + "] occurs at [" + ((URL)object2).toString() + "]", this.loggerContext));
            }
        }
    }
}

