/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.status.StatusUtil;
import java.net.URL;

class ReconfigureOnChangeFilter$ReconfiguringThread
implements Runnable {
    final /* synthetic */ ReconfigureOnChangeFilter this$0;

    ReconfigureOnChangeFilter$ReconfiguringThread(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        this.this$0 = reconfigureOnChangeFilter;
    }

    @Override
    public void run() {
        if (this.this$0.mainConfigurationURL == null) {
            this.this$0.addInfo("Due to missing top level configuration file, skipping reconfiguration");
            return;
        }
        LoggerContext loggerContext = (LoggerContext)ReconfigureOnChangeFilter.access$000(this.this$0);
        this.this$0.addInfo("Will reset and reconfigure context named [" + ReconfigureOnChangeFilter.access$100(this.this$0).getName() + "]");
        if (this.this$0.mainConfigurationURL.toString().endsWith("xml")) {
            this.performXMLConfiguration(loggerContext);
            return;
        }
        if (this.this$0.mainConfigurationURL.toString().endsWith("groovy")) {
            this.this$0.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(ReconfigureOnChangeFilter.access$200(this.this$0));
        StatusUtil statusUtil = new StatusUtil(ReconfigureOnChangeFilter.access$300(this.this$0));
        Model model = joranConfigurator.recallSafeConfiguration();
        URL uRL = ConfigurationWatchListUtil.getMainWatchURL(ReconfigureOnChangeFilter.access$400(this.this$0));
        ((ContextBase)loggerContext).reset();
        long l2 = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(this.this$0.mainConfigurationURL);
            if (statusUtil.hasXMLParsingErrors(l2)) {
                this.fallbackConfiguration(loggerContext, model, uRL);
            }
            return;
        }
        catch (JoranException joranException) {
            this.fallbackConfiguration(loggerContext, model, uRL);
            return;
        }
    }

    private void fallbackConfiguration(LoggerContext loggerContext, Model model, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(ReconfigureOnChangeFilter.access$500(this.this$0));
        if (model != null) {
            this.this$0.addWarn("Falling back to previously registered safe configuration.");
            try {
                ((ContextBase)loggerContext).reset();
                JoranConfigurator.informContextOfURLUsedForConfiguration(ReconfigureOnChangeFilter.access$600(this.this$0), uRL);
                ModelUtil.resetForReuse(model);
                joranConfigurator.processModel(model);
                this.this$0.addInfo("Re-registering previous fallback configuration once more as a fallback configuration point");
                joranConfigurator.registerSafeConfiguration(model);
                return;
            }
            catch (Exception exception) {
                this.this$0.addError("Unexpected exception thrown by a configuration considered safe.", exception);
                return;
            }
        }
        this.this$0.addWarn("No previous configuration to fall back on.");
    }
}

