/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.List;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    CachingDateFormatter cachingDateFormatter = null;

    @Override
    public void start() {
        String string = this.getFirstOption();
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (string.equals("ISO8601")) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        List<String> list = this.getOptionList();
        ZoneId zoneId = null;
        if (list != null && list.size() > 1) {
            zoneId = ZoneId.of(list.get(1));
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(string, zoneId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern ".concat(String.valueOf(string)), illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", zoneId);
        }
        super.start();
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        long l2 = iLoggingEvent.getTimeStamp();
        return this.cachingDateFormatter.format(l2);
    }
}

