/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final Duration SCAN_PERIOD_DEFAULT = Duration.buildByMinutes(1.0);

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ConfigurationModelHandler(context);
    }

    public Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        model = (ConfigurationModel)model;
        Object object = OptionHelper.getSystemProperty("logback.debug", null);
        if (object == null) {
            object = modelInterpretationContext.subst(((ConfigurationModel)model).getDebugStr());
        }
        if (!(OptionHelper.isNullOrEmpty((String)object) || ((String)object).equalsIgnoreCase(Boolean.FALSE.toString()) || ((String)object).equalsIgnoreCase("null"))) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(modelInterpretationContext, (ConfigurationModel)model);
        object = (LoggerContext)this.context;
        boolean bl2 = OptionHelper.toBoolean(modelInterpretationContext.subst(((ConfigurationModel)model).getPackagingDataStr()), false);
        ((LoggerContext)object).setPackagingDataEnabled(bl2);
        new ContextUtil(this.context).addGroovyPackages(((LoggerContext)object).getFrameworkPackages());
    }

    void processScanAttrib(ModelInterpretationContext scheduledFuture, ConfigurationModel configurationModel) {
        Object object = ((ModelInterpretationContext)((Object)scheduledFuture)).subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmpty((String)object) && !"false".equalsIgnoreCase((String)object)) {
            object = this.context.getScheduledExecutorService();
            URL uRL = ConfigurationWatchListUtil.getMainWatchURL(this.context);
            if (uRL == null) {
                this.addWarn("Due to missing top level configuration file, reconfiguration on change (configuration file scanning) cannot be done.");
                return;
            }
            ReconfigureOnChangeTask reconfigureOnChangeTask = new ReconfigureOnChangeTask();
            reconfigureOnChangeTask.setContext(this.context);
            this.addInfo("Registering a new ReconfigureOnChangeTask ".concat(String.valueOf(reconfigureOnChangeTask)));
            this.context.putObject("RECONFIGURE_ON_CHANGE_TASK", reconfigureOnChangeTask);
            scheduledFuture = ((ModelInterpretationContext)((Object)scheduledFuture)).subst(configurationModel.getScanPeriodStr());
            scheduledFuture = this.getDurationOfScanPeriodAttribute((String)((Object)scheduledFuture), SCAN_PERIOD_DEFAULT);
            this.addInfo("Will scan for changes in [" + uRL + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to ".concat(String.valueOf(scheduledFuture)));
            scheduledFuture = object.scheduleAtFixedRate(reconfigureOnChangeTask, ((Duration)((Object)scheduledFuture)).getMilliseconds(), ((Duration)((Object)scheduledFuture)).getMilliseconds(), TimeUnit.MILLISECONDS);
            this.context.addScheduledFuture(scheduledFuture);
        }
    }

    private Duration getDurationOfScanPeriodAttribute(String string, Duration duration) {
        Duration duration2 = null;
        if (!OptionHelper.isNullOrEmpty(string)) {
            try {
                duration2 = Duration.valueOf(string);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                this.addWarn("Failed to parse 'scanPeriod' attribute [" + string + "]", runtimeException);
            }
        }
        if (duration2 == null) {
            this.addInfo("No 'scanPeriod' specified. Defaulting to " + duration.toString());
            duration2 = duration;
        }
        return duration2;
    }
}

