/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners = null;

    void addListener(ReconfigureOnChangeTaskListener reconfigureOnChangeTaskListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ReconfigureOnChangeTaskListener>(1);
        }
        this.listeners.add(reconfigureOnChangeTaskListener);
    }

    @Override
    public void run() {
        this.fireEnteredRunMethod();
        Object object = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        if (object == null) {
            this.addWarn("Empty ConfigurationWatchList in context");
            return;
        }
        List<File> list = ((ConfigurationWatchList)object).getCopyOfFileWatchList();
        if (list == null || list.isEmpty()) {
            this.addInfo("Empty watch file list. Disabling ");
            return;
        }
        if (!((ConfigurationWatchList)object).changeDetected()) {
            return;
        }
        this.fireChangeDetected();
        object = ((ConfigurationWatchList)object).getMainURL();
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        this.addInfo("Will reset and reconfigure context named [" + this.context.getName() + "]");
        list = (LoggerContext)this.context;
        if (((URL)object).toString().endsWith("xml")) {
            this.performXMLConfiguration((LoggerContext)((Object)list), (URL)object);
        } else if (((URL)object).toString().endsWith("groovy")) {
            this.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
        this.fireDoneReconfiguring();
    }

    private void fireEnteredRunMethod() {
        if (this.listeners == null) {
            return;
        }
        Iterator<ReconfigureOnChangeTaskListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().enteredRunMethod();
        }
    }

    private void fireChangeDetected() {
        if (this.listeners == null) {
            return;
        }
        Iterator<ReconfigureOnChangeTaskListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().changeDetected();
        }
    }

    private void fireDoneReconfiguring() {
        if (this.listeners == null) {
            return;
        }
        Iterator<ReconfigureOnChangeTaskListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().doneReconfiguring();
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        Model model = joranConfigurator.recallSafeConfiguration();
        URL uRL2 = ConfigurationWatchListUtil.getMainWatchURL(this.context);
        ((ContextBase)loggerContext).reset();
        long l2 = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(uRL);
            if (statusUtil.hasXMLParsingErrors(l2)) {
                this.fallbackConfiguration(loggerContext, model, uRL2);
            }
            return;
        }
        catch (JoranException joranException) {
            this.fallbackConfiguration(loggerContext, model, uRL2);
            return;
        }
    }

    private void fallbackConfiguration(LoggerContext loggerContext, Model model, URL object) {
        object = new JoranConfigurator();
        ((ContextAwareBase)object).setContext(this.context);
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context).buildClone();
        if (model == null) {
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        this.addInfo("Safe model ".concat(String.valueOf(model)));
        try {
            ((ContextBase)loggerContext).reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList(this.context, configurationWatchList);
            ModelUtil.resetForReuse(model);
            ((GenericXMLConfigurator)object).processModel(model);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            ((GenericXMLConfigurator)object).registerSafeConfiguration(model);
            this.addInfo("after registerSafeConfiguration");
            return;
        }
        catch (Exception exception) {
            this.addError("Unexpected exception thrown by a configuration considered safe.", exception);
            return;
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }
}

