/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusUtil;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanUtil {
    static final String DOMAIN = "ch.qos.logback.classic";

    public static String getObjectNameFor(String string, Class<?> clazz) {
        return "ch.qos.logback.classic:Name=" + string + ",Type=" + clazz.getName();
    }

    public static ObjectName string2ObjectName(Context object, Object object2, String string) {
        String string2 = "Failed to convert [" + string + "] to ObjectName";
        object = new StatusUtil((Context)object);
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ((StatusUtil)object).addError(object2, string2, malformedObjectNameException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            ((StatusUtil)object).addError(object2, string2, nullPointerException);
            return null;
        }
    }

    public static boolean isRegistered(MBeanServer mBeanServer, ObjectName objectName) {
        return mBeanServer.isRegistered(objectName);
    }

    public static void createAndRegisterJMXConfigurator(MBeanServer mBeanServer, LoggerContext loggerContext, JMXConfigurator jMXConfigurator, ObjectName objectName, Object object) {
        try {
            mBeanServer.registerMBean(jMXConfigurator, objectName);
            return;
        }
        catch (Exception exception) {
            new StatusUtil(loggerContext).addError(object, "Failed to create mbean", exception);
            return;
        }
    }

    public static void unregister(LoggerContext object, MBeanServer mBeanServer, ObjectName objectName, Object object2) {
        object = new StatusUtil((Context)object);
        if (mBeanServer.isRegistered(objectName)) {
            try {
                ((StatusUtil)object).addInfo(object2, "Unregistering mbean [" + objectName + "]");
                mBeanServer.unregisterMBean(objectName);
                return;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                ((StatusUtil)object).addError(object2, "Failed to unregister mbean".concat(String.valueOf(objectName)), instanceNotFoundException);
                return;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                ((StatusUtil)object).addError(object2, "Failed to unregister mbean".concat(String.valueOf(objectName)), mBeanRegistrationException);
                return;
            }
        }
        ((StatusUtil)object).addInfo(object2, "mbean [" + objectName + "] does not seem to be registered");
    }
}

