/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfiguratorMBean;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusListenerAsList;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JMXConfigurator
extends ContextAwareBase
implements JMXConfiguratorMBean,
LoggerContextListener {
    private static String EMPTY = "";
    LoggerContext loggerContext;
    MBeanServer mbs;
    ObjectName objectName;
    String objectNameAsString;
    boolean debug = true;
    boolean started = true;

    public JMXConfigurator(LoggerContext loggerContext, MBeanServer mBeanServer, ObjectName objectName) {
        this.context = loggerContext;
        this.loggerContext = loggerContext;
        this.mbs = mBeanServer;
        this.objectName = objectName;
        this.objectNameAsString = objectName.toString();
        if (this.previouslyRegisteredListenerWithSameObjectName()) {
            this.addError("Previously registered JMXConfigurator named [" + this.objectNameAsString + "] in the logger context named [" + loggerContext.getName() + "]");
            return;
        }
        loggerContext.addListener(this);
    }

    private boolean previouslyRegisteredListenerWithSameObjectName() {
        for (LoggerContextListener loggerContextListener : this.loggerContext.getCopyOfListenerList()) {
            if (!(loggerContextListener instanceof JMXConfigurator)) continue;
            loggerContextListener = (JMXConfigurator)loggerContextListener;
            if (!this.objectName.equals(((JMXConfigurator)loggerContextListener).objectName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reloadDefaultConfiguration() throws JoranException {
        URL uRL = new ContextInitializer(this.loggerContext).findURLOfDefaultConfigurationFile(true);
        this.reloadByURL(uRL);
    }

    @Override
    public void reloadByFileName(String object) throws JoranException, FileNotFoundException {
        File file = new File((String)object);
        if (file.exists() && file.isFile()) {
            try {
                object = file.toURI().toURL();
                this.reloadByURL((URL)object);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Unexpected MalformedURLException occured. See nexted cause.", malformedURLException);
            }
        }
        object = "Could not find [" + (String)object + "]";
        this.addInfo((String)object);
        throw new FileNotFoundException((String)object);
    }

    void addStatusListener(StatusListener statusListener) {
        this.loggerContext.getStatusManager().add(statusListener);
    }

    void removeStatusListener(StatusListener statusListener) {
        this.loggerContext.getStatusManager().remove(statusListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reloadByURL(URL uRL) throws JoranException {
        StatusListenerAsList statusListenerAsList = new StatusListenerAsList();
        this.addStatusListener(statusListenerAsList);
        this.addInfo("Resetting context: " + this.loggerContext.getName());
        ((ContextBase)this.loggerContext).reset();
        this.addStatusListener(statusListenerAsList);
        try {
            if (uRL != null) {
                JoranConfigurator joranConfigurator = new JoranConfigurator();
                joranConfigurator.setContext(this.loggerContext);
                joranConfigurator.doConfigure(uRL);
                this.addInfo("Context: " + this.loggerContext.getName() + " reloaded.");
            }
            this.removeStatusListener(statusListenerAsList);
            if (!this.debug) return;
        }
        catch (Throwable throwable) {
            this.removeStatusListener(statusListenerAsList);
            if (!this.debug) throw throwable;
            StatusPrinter.print(statusListenerAsList.getStatusList());
            throw throwable;
        }
        StatusPrinter.print(statusListenerAsList.getStatusList());
    }

    @Override
    public void setLoggerLevel(String object, String object2) {
        if (object == null) {
            return;
        }
        if (object2 == null) {
            return;
        }
        object = ((String)object).trim();
        object2 = ((String)object2).trim();
        this.addInfo("Trying to set level " + (String)object2 + " to logger " + (String)object);
        object = ((LoggerContext)this.context).getLogger((String)object);
        if ("null".equalsIgnoreCase((String)object2)) {
            ((Logger)object).setLevel(null);
            return;
        }
        if ((object2 = Level.toLevel((String)object2, null)) != null) {
            ((Logger)object).setLevel((Level)object2);
        }
    }

    @Override
    public String getLoggerLevel(String object) {
        if (object == null) {
            return EMPTY;
        }
        object = ((String)object).trim();
        if ((object = ((LoggerContext)this.context).exists((String)object)) != null && ((Logger)object).getLevel() != null) {
            return ((Logger)object).getLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public String getLoggerEffectiveLevel(String object) {
        if (object == null) {
            return EMPTY;
        }
        object = ((String)object).trim();
        if ((object = ((LoggerContext)this.context).exists((String)object)) != null) {
            return ((Logger)object).getEffectiveLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public List<String> getLoggerList() {
        LoggerContext loggerContext = (LoggerContext)this.context;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Logger logger : loggerContext.getLoggerList()) {
            arrayList.add(logger.getName());
        }
        return arrayList;
    }

    @Override
    public List<String> getStatuses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Status> iterator = this.context.getStatusManager().getCopyOfStatusList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        return arrayList;
    }

    @Override
    public void onStop(LoggerContext loggerContext) {
        if (!this.started) {
            this.addInfo("onStop() method called on a stopped JMXActivator [" + this.objectNameAsString + "]");
            return;
        }
        if (this.mbs.isRegistered(this.objectName)) {
            try {
                this.addInfo("Unregistering mbean [" + this.objectNameAsString + "]");
                this.mbs.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                this.addError("Unable to find a verifiably registered mbean [" + this.objectNameAsString + "]", instanceNotFoundException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                this.addError("Failed to unregister [" + this.objectNameAsString + "]", mBeanRegistrationException);
            }
        } else {
            this.addInfo("mbean [" + this.objectNameAsString + "] was not in the mbean registry. This is OK.");
        }
        this.stop();
    }

    @Override
    public void onLevelChange(Logger logger, Level level) {
    }

    @Override
    public void onReset(LoggerContext loggerContext) {
        this.addInfo("onReset() method called JMXActivator [" + this.objectNameAsString + "]");
    }

    @Override
    public boolean isResetResistant() {
        return true;
    }

    private void clearFields() {
        this.mbs = null;
        this.objectName = null;
        this.loggerContext = null;
    }

    private void stop() {
        this.started = false;
        this.clearFields();
    }

    @Override
    public void onStart(LoggerContext loggerContext) {
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.context.getName() + ")";
    }
}

