/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultCssBuilder;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++n2;
        }
        if (n2 == 0) {
            super.start();
        }
    }

    @Override
    public Map<String, String> getDefaultConverterMap() {
        return PatternLayout.DEFAULT_CONVERTER_MAP;
    }

    @Override
    public String doLayout(ILoggingEvent iLoggingEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        this.startNewTableIfLimitReached(stringBuilder);
        boolean bl2 = true;
        if ((this.counter++ & 1L) == 0L) {
            bl2 = false;
        }
        String string = iLoggingEvent.getLevel().toString().toLowerCase();
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<tr class=\"");
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" odd\">");
        } else {
            stringBuilder.append(" even\">");
        }
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        for (Converter converter = this.head; converter != null; converter = converter.getNext()) {
            this.appendEventToBuffer(stringBuilder, converter, iLoggingEvent);
        }
        stringBuilder.append("</tr>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.throwableRenderer.render(stringBuilder, iLoggingEvent);
        }
        return stringBuilder.toString();
    }

    private void appendEventToBuffer(StringBuilder stringBuilder, Converter<ILoggingEvent> converter, ILoggingEvent iLoggingEvent) {
        stringBuilder.append("<td class=\"");
        stringBuilder.append(((HTMLLayoutBase)this).computeConverterName(converter));
        stringBuilder.append("\">");
        stringBuilder.append(Transform.escapeTags(converter.convert(iLoggingEvent)));
        stringBuilder.append("</td>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer<ILoggingEvent> getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> iThrowableRenderer) {
        this.throwableRenderer = iThrowableRenderer;
    }

    @Override
    public String computeConverterName(Converter<ILoggingEvent> object) {
        if (object instanceof MDCConverter) {
            if ((object = ((MDCConverter)object).getFirstOption()) != null) {
                return object;
            }
            return "MDC";
        }
        return super.computeConverterName(object);
    }
}

