/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.IThrowableRenderer;

public class DefaultThrowableRenderer
implements IThrowableRenderer<ILoggingEvent> {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";

    @Override
    public void render(StringBuilder stringBuilder, ILoggingEvent object) {
        stringBuilder.append("<tr><td class=\"Exception\" colspan=\"6\">");
        for (object = object.getThrowableProxy(); object != null; object = object.getCause()) {
            this.render(stringBuilder, (IThrowableProxy)object);
        }
        stringBuilder.append("</td></tr>");
    }

    @Override
    void render(StringBuilder stringBuilder, IThrowableProxy stackTraceElementProxyArray) {
        this.printFirstLine(stringBuilder, (IThrowableProxy)stackTraceElementProxyArray);
        int n2 = stackTraceElementProxyArray.getCommonFrames();
        stackTraceElementProxyArray = stackTraceElementProxyArray.getStackTraceElementProxyArray();
        for (int i2 = 0; i2 < stackTraceElementProxyArray.length - n2; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i2];
            stringBuilder.append(TRACE_PREFIX);
            stringBuilder.append(Transform.escapeTags(stackTraceElementProxy.toString()));
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n2 > 0) {
            stringBuilder.append(TRACE_PREFIX);
            stringBuilder.append("\t... ").append(n2).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void printFirstLine(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.getCommonFrames() > 0) {
            stringBuilder.append("<br />Caused by: ");
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(Transform.escapeTags(iThrowableProxy.getMessage()));
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }
}

