/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSize {
    private static final String LENGTH_PART = "([0-9]+)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|kb|mb|gb)s?";
    private static final int UNIT_GROUP = 2;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    public static final long KB_COEFFICIENT = 1024L;
    public static final long MB_COEFFICIENT = 0x100000L;
    public static final long GB_COEFFICIENT = 0x40000000L;
    final long size;

    public FileSize(long l2) {
        this.size = l2;
    }

    public long getSize() {
        return this.size;
    }

    public static FileSize valueOf(String string) {
        Object object = FILE_SIZE_PATTERN.matcher(string);
        if (((Matcher)object).matches()) {
            long l2;
            string = ((Matcher)object).group(1);
            object = ((Matcher)object).group(2);
            long l3 = Long.valueOf(string);
            if (((String)object).equalsIgnoreCase("")) {
                l2 = 1L;
            } else if (((String)object).equalsIgnoreCase("kb")) {
                l2 = 1024L;
            } else if (((String)object).equalsIgnoreCase("mb")) {
                l2 = 0x100000L;
            } else if (((String)object).equalsIgnoreCase("gb")) {
                l2 = 0x40000000L;
            } else {
                throw new IllegalStateException("Unexpected ".concat(String.valueOf(object)));
            }
            return new FileSize(l3 * l2);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }

    public String toString() {
        long l2 = this.size / 1024L;
        if (l2 == 0L) {
            return this.size + " Bytes";
        }
        long l3 = this.size / 0x100000L;
        if (l3 == 0L) {
            return l2 + " KB";
        }
        long l4 = this.size / 0x40000000L;
        if (l4 == 0L) {
            return l3 + " MB";
        }
        return l4 + " GB";
    }
}

