/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceState;
import java.text.DateFormatSymbols;

class CharSequenceToRegexMapper {
    DateFormatSymbols symbols = DateFormatSymbols.getInstance();

    CharSequenceToRegexMapper() {
    }

    String toRegex(CharSequenceState charSequenceState) {
        int n2 = charSequenceState.occurrences;
        char c2 = charSequenceState.c;
        switch (charSequenceState.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (n2 <= 2) {
                    return this.number(n2);
                }
                if (n2 == 3) {
                    return this.getRegexForShortMonths();
                }
                return this.getRegexForLongMonths();
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(n2);
            }
            case 'E': {
                if (n2 >= 4) {
                    return this.getRegexForLongDaysOfTheWeek();
                }
                return this.getRegexForShortDaysOfTheWeek();
            }
            case 'a': {
                return this.getRegexForAmPms();
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (n2 == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (n2 == 1) {
            return String.valueOf(c2);
        }
        return c2 + "{" + n2 + "}";
    }

    private String number(int n2) {
        return "\\d{" + n2 + "}";
    }

    private String getRegexForAmPms() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getAmPmStrings());
    }

    private String getRegexForLongDaysOfTheWeek() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getWeekdays());
    }

    private String getRegexForShortDaysOfTheWeek() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getShortWeekdays());
    }

    private String getRegexForLongMonths() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getMonths());
    }

    String getRegexForShortMonths() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getShortMonths());
    }

    private String symbolArrayToRegex(String[] objectArray) {
        objectArray = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols(objectArray);
        return ".{" + (int)objectArray[0] + "," + (int)objectArray[1] + "}";
    }

    static int[] findMinMaxLengthsInSymbols(String[] stringArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = stringArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = stringArray[i2].length();
            if (n5 == 0) continue;
            n2 = Math.min(n2, n5);
            n3 = Math.max(n3, n5);
        }
        return new int[]{n2, n3};
    }
}

