/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class StatusUtil {
    StatusManager sm;

    public StatusUtil(StatusManager statusManager) {
        this.sm = statusManager;
    }

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context list) {
        if ((list = list.getStatusManager()) == null) {
            return false;
        }
        return (list = list.getCopyOfStatusListenerList()) != null && list.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> object, long l2) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            if (status.getDate() < l2) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public void addStatus(Status status) {
        if (this.sm != null) {
            this.sm.add(status);
        }
    }

    public void addInfo(Object object, String string) {
        this.addStatus(new InfoStatus(string, object));
    }

    public void addWarn(Object object, String string) {
        this.addStatus(new WarnStatus(string, object));
    }

    public void addError(Object object, String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, object, throwable));
    }

    public boolean hasXMLParsingErrors(long l2) {
        return this.containsMatch(l2, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long l2) {
        return !this.hasXMLParsingErrors(l2);
    }

    public int getHighestLevel(long l2) {
        Object object = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            if (status.getLevel() <= n2) continue;
            n2 = status.getLevel();
        }
        return n2;
    }

    public boolean isErrorFree(long l2) {
        return 2 > this.getHighestLevel(l2);
    }

    public boolean isWarningOrErrorFree(long l2) {
        return 1 > this.getHighestLevel(l2);
    }

    public boolean containsMatch(long l2, int n2, String object) {
        Object object2 = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        Pattern pattern = Pattern.compile((String)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (Status)object2.next();
            if (n2 != object.getLevel() || !pattern.matcher((CharSequence)(object = object.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int n2, String string) {
        return this.containsMatch(0L, n2, string);
    }

    public boolean containsMatch(String object) {
        object = Pattern.compile((String)object);
        Iterator<Status> iterator = this.sm.getCopyOfStatusList().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getMessage();
            if (!((Pattern)object).matcher(string).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int matchCount(String object) {
        int n2 = 0;
        object = Pattern.compile((String)object);
        Iterator<Status> iterator = this.sm.getCopyOfStatusList().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getMessage();
            if (!((Pattern)object).matcher(string).lookingAt()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean containsException(Class<?> clazz) {
        return this.containsException(clazz, null);
    }

    public boolean containsException(Class<?> clazz, String string) {
        Iterator<Status> iterator = this.sm.getCopyOfStatusList().iterator();
        while (iterator.hasNext()) {
            for (Throwable throwable = iterator.next().getThrowable(); throwable != null; throwable = throwable.getCause()) {
                if (!throwable.getClass().getName().equals(clazz.getName())) continue;
                if (string == null) {
                    return true;
                }
                if (!this.checkRegexMatch(throwable.getMessage(), string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRegexMatch(String string, String string2) {
        return Pattern.compile(string2).matcher(string).lookingAt();
    }

    public long timeOfLastReset() {
        List<Status> list = this.sm.getCopyOfStatusList();
        if (list == null) {
            return -1L;
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Status status = list.get(i2);
            if (!"Will reset and reconfigure context ".equals(status.getMessage())) continue;
            return status.getDate();
        }
        return -1L;
    }
}

