/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover$1;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

public class SizeAndTimeBasedArchiveRemover
extends TimeBasedArchiveRemover {
    protected static final int NO_INDEX = -1;

    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        super(fileNamePattern, rollingCalendar);
    }

    @Override
    protected File[] getFilesInPeriod(Date object) {
        File file = new File(this.fileNamePattern.convertMultipleArguments(object, 0));
        file = this.getParentDir(file);
        object = this.createStemRegex((Date)object);
        return FileFilterUtil.filesInFolderMatchingStemRegex(file, (String)object);
    }

    private String createStemRegex(Date date) {
        return FileFilterUtil.afterLastSlash(this.fileNamePattern.toRegexForFixedDate(date));
    }

    @Override
    protected void descendingSort(File[] fileArray, Date serializable) {
        serializable = Pattern.compile(this.createStemRegex((Date)serializable));
        Arrays.sort(fileArray, new SizeAndTimeBasedArchiveRemover$1(this, (Pattern)serializable));
    }
}

