/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.RemoteReceiverClient;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;

class RemoteReceiverStreamClient
extends ContextAwareBase
implements RemoteReceiverClient {
    private final String clientId;
    private final Socket socket;
    private final OutputStream outputStream;
    private BlockingQueue<Serializable> queue;

    public RemoteReceiverStreamClient(String string, Socket socket) {
        this.clientId = "client " + string + ": ";
        this.socket = socket;
        this.outputStream = null;
    }

    RemoteReceiverStreamClient(String string, OutputStream outputStream) {
        this.clientId = "client " + string + ": ";
        this.socket = null;
        this.outputStream = outputStream;
    }

    @Override
    public void setQueue(BlockingQueue<Serializable> blockingQueue) {
        this.queue = blockingQueue;
    }

    @Override
    public boolean offer(Serializable serializable) {
        if (this.queue == null) {
            throw new IllegalStateException("client has no event queue");
        }
        return this.queue.offer(serializable);
    }

    @Override
    public void close() {
        if (this.socket == null) {
            return;
        }
        CloseUtil.closeQuietly(this.socket);
    }

    @Override
    public void run() {
        this.addInfo(this.clientId + "connected");
        ObjectOutputStream objectOutputStream = null;
        try {
            int n2 = 0;
            objectOutputStream = this.createObjectOutputStream();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Serializable serializable = this.queue.take();
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.flush();
                    if (++n2 < 70) continue;
                    n2 = 0;
                    objectOutputStream.reset();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
        catch (SocketException socketException) {
            this.addInfo(this.clientId + socketException);
            return;
        }
        catch (IOException iOException) {
            this.addError(this.clientId + iOException);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.addError(this.clientId + runtimeException);
            return;
        }
        finally {
            if (objectOutputStream != null) {
                CloseUtil.closeQuietly(objectOutputStream);
            }
            this.close();
            this.addInfo(this.clientId + "connection closed");
        }
    }

    private ObjectOutputStream createObjectOutputStream() throws IOException {
        if (this.socket == null) {
            return new ObjectOutputStream(this.outputStream);
        }
        return new ObjectOutputStream(this.socket.getOutputStream());
    }
}

