/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelHandlerFactoryMethod;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.DefaultProcessor$1;
import ch.qos.logback.core.model.processor.DefaultProcessor$TraverseMethod;
import ch.qos.logback.core.model.processor.ModelFilter;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.PhaseIndicator;
import ch.qos.logback.core.model.processor.ProcessingPhase;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;

public class DefaultProcessor
extends ContextAwareBase {
    protected final ModelInterpretationContext mic;
    final HashMap<Class<? extends Model>, ModelHandlerFactoryMethod> modelClassToHandlerMap = new HashMap();
    final HashMap<Class<? extends Model>, Supplier<ModelHandlerBase>> modelClassToDependencyAnalyserMap = new HashMap();
    ChainedModelFilter phaseOneFilter = new ChainedModelFilter();
    ChainedModelFilter phaseTwoFilter = new ChainedModelFilter();
    static final int DENIED = -1;

    public DefaultProcessor(Context context, ModelInterpretationContext modelInterpretationContext) {
        this.setContext(context);
        this.mic = modelInterpretationContext;
    }

    public void addHandler(Class<? extends Model> clazz, ModelHandlerFactoryMethod object) {
        this.modelClassToHandlerMap.put(clazz, (ModelHandlerFactoryMethod)object);
        object = this.determineProcessingPhase(clazz);
        switch (DefaultProcessor$1.$SwitchMap$ch$qos$logback$core$model$processor$ProcessingPhase[((Enum)object).ordinal()]) {
            case 1: {
                this.getPhaseOneFilter().allow(clazz);
                return;
            }
            case 2: {
                this.getPhaseTwoFilter().allow(clazz);
                return;
            }
        }
        throw new IllegalArgumentException("unexpected value " + object + " for model class " + clazz.getName());
    }

    private ProcessingPhase determineProcessingPhase(Class<? extends Model> object) {
        if ((object = ((Class)object).getAnnotation(PhaseIndicator.class)) == null) {
            return ProcessingPhase.FIRST;
        }
        return object.phase();
    }

    public void addAnalyser(Class<? extends Model> clazz, Supplier<ModelHandlerBase> supplier) {
        this.modelClassToDependencyAnalyserMap.put(clazz, supplier);
    }

    private void traversalLoop(DefaultProcessor$TraverseMethod defaultProcessor$TraverseMethod, Model model, ModelFilter modelFilter, String string) {
        for (int i2 = 0; i2 < 3 && defaultProcessor$TraverseMethod.traverse(model, modelFilter) != 0; ++i2) {
        }
    }

    public void process(Model model) {
        if (model == null) {
            this.addError("Expecting non null model to process");
            return;
        }
        this.initialObjectPush();
        this.mainTraverse(model, this.getPhaseOneFilter());
        this.analyseDependencies(model);
        DefaultProcessor defaultProcessor = this;
        defaultProcessor.traversalLoop(defaultProcessor::secondPhaseTraverse, model, this.getPhaseTwoFilter(), "phase 2");
        this.addInfo("End of configuration.");
        this.finalObjectPop();
    }

    private void finalObjectPop() {
        this.mic.popObject();
    }

    private void initialObjectPush() {
        this.mic.pushObject(this.context);
    }

    public ChainedModelFilter getPhaseOneFilter() {
        return this.phaseOneFilter;
    }

    public ChainedModelFilter getPhaseTwoFilter() {
        return this.phaseTwoFilter;
    }

    protected void analyseDependencies(Model model) {
        Supplier<ModelHandlerBase> supplier = this.modelClassToDependencyAnalyserMap.get(model.getClass());
        ModelHandlerBase modelHandlerBase = null;
        if (supplier != null) {
            modelHandlerBase = supplier.get();
        }
        if (modelHandlerBase != null) {
            try {
                modelHandlerBase.handle(this.mic, model);
            }
            catch (ModelHandlerException modelHandlerException) {
                this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
            }
        }
        for (Model model2 : model.getSubModels()) {
            this.analyseDependencies(model2);
        }
        if (modelHandlerBase != null) {
            try {
                modelHandlerBase.postHandle(this.mic, model);
                return;
            }
            catch (ModelHandlerException modelHandlerException) {
                this.addError("Failed to invoke postHandle on model " + model.getTag(), modelHandlerException);
            }
        }
    }

    private ModelHandlerBase createHandler(Model model) {
        Object object = this.modelClassToHandlerMap.get(model.getClass());
        if (object == null) {
            this.addError("Can't handle model of type " + model.getClass() + "  with tag: " + model.getTag() + " at line " + model.getLineNumber());
            return null;
        }
        if ((object = object.make(this.context, this.mic)) == null) {
            return null;
        }
        if (!((ModelHandlerBase)object).isSupportedModelType(model)) {
            this.addWarn("Handler [" + object.getClass() + "] does not support " + model.idString());
            return null;
        }
        return object;
    }

    protected int mainTraverse(Model model, ModelFilter modelFilter) {
        if (modelFilter.decide(model) == FilterReply.DENY) {
            return -1;
        }
        int n2 = 0;
        try {
            ModelHandlerBase modelHandlerBase = null;
            boolean bl2 = model.isUnhandled();
            if (bl2 && (modelHandlerBase = this.createHandler(model)) != null) {
                modelHandlerBase.handle(this.mic, model);
                model.markAsHandled();
                ++n2;
            }
            if (!model.isSkipped()) {
                for (Model model2 : model.getSubModels()) {
                    n2 += this.mainTraverse(model2, modelFilter);
                }
            }
            if (bl2 && modelHandlerBase != null) {
                modelHandlerBase.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
        }
        return n2;
    }

    protected int secondPhaseTraverse(Model model, ModelFilter modelFilter) {
        if (modelFilter.decide(model) == FilterReply.DENY) {
            return 0;
        }
        int n2 = 0;
        try {
            boolean bl2 = this.allDependenciesStarted(model);
            ModelHandlerBase modelHandlerBase = null;
            if (model.isUnhandled() && bl2 && (modelHandlerBase = this.createHandler(model)) != null) {
                modelHandlerBase.handle(this.mic, model);
                model.markAsHandled();
                ++n2;
            }
            if (!bl2 && !this.dependencyIsADirectSubmodel(model)) {
                return n2;
            }
            if (!model.isSkipped()) {
                for (Model model2 : model.getSubModels()) {
                    n2 += this.secondPhaseTraverse(model2, modelFilter);
                }
            }
            if (modelHandlerBase != null) {
                modelHandlerBase.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
        }
        return n2;
    }

    private boolean dependencyIsADirectSubmodel(Model object) {
        List<String> list = this.mic.getDependeeNamesForModel((Model)((Object)object));
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Model model : ((Model)((Object)object)).getSubModels()) {
            String string;
            if (!(model instanceof NamedComponentModel) || !list.contains(string = ((NamedComponentModel)model).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean allDependenciesStarted(Model iterator) {
        if ((iterator = this.mic.getDependeeNamesForModel((Model)((Object)iterator))) == null || iterator.isEmpty()) {
            return true;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.mic.isNamedDependeeStarted(string)) continue;
            return false;
        }
        return true;
    }

    ModelHandlerBase instantiateHandler(Class<? extends ModelHandlerBase> clazz) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = this.getWithContextConstructor(clazz);
            if (constructor != null) {
                return constructor.newInstance(this.context);
            }
            constructor = this.getWithContextAndBDCConstructor(clazz);
            if (constructor != null) {
                return constructor.newInstance(this.context, this.mic.getBeanDescriptionCache());
            }
            this.addError("Failed to find suitable constructor for class [" + clazz + "]");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            this.addError("Failed to instantiate ".concat(String.valueOf(clazz)));
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextConstructor(Class<? extends ModelHandlerBase> clazz) {
        try {
            return clazz.getConstructor(Context.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextAndBDCConstructor(Class<? extends ModelHandlerBase> clazz) {
        try {
            return clazz.getConstructor(Context.class, BeanDescriptionCache.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

