/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util.beans;

import java.lang.reflect.Method;

public class BeanUtil {
    public static final String PREFIX_GETTER_IS = "is";
    public static final String PREFIX_GETTER_GET = "get";
    public static final String PREFIX_SETTER = "set";
    public static final String PREFIX_ADDER = "add";

    public static boolean isAdder(Method method) {
        if (BeanUtil.getParameterCount(method) != 1) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        return method.getName().startsWith(PREFIX_ADDER);
    }

    public static boolean isGetter(Method object) {
        if (BeanUtil.getParameterCount((Method)object) > 0) {
            return false;
        }
        Class<?> clazz = ((Method)object).getReturnType();
        if (clazz == Void.TYPE) {
            return false;
        }
        if (!((String)(object = ((Method)object).getName())).startsWith(PREFIX_GETTER_GET) && !((String)object).startsWith(PREFIX_GETTER_IS)) {
            return false;
        }
        return !((String)object).startsWith(PREFIX_GETTER_IS) || clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    private static int getParameterCount(Method method) {
        return method.getParameterTypes().length;
    }

    public static boolean isSetter(Method method) {
        if (BeanUtil.getParameterCount(method) != 1) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        return method.getName().startsWith(PREFIX_SETTER);
    }

    public static String getPropertyName(Method object) {
        String string = BeanUtil.getSubstringIfPrefixMatches((String)(object = ((Method)object).getName()), PREFIX_GETTER_GET);
        if (string == null) {
            string = BeanUtil.getSubstringIfPrefixMatches((String)object, PREFIX_SETTER);
        }
        if (string == null) {
            string = BeanUtil.getSubstringIfPrefixMatches((String)object, PREFIX_GETTER_IS);
        }
        if (string == null) {
            string = BeanUtil.getSubstringIfPrefixMatches((String)object, PREFIX_ADDER);
        }
        return BeanUtil.toLowerCamelCase(string);
    }

    public static String toLowerCamelCase(String object) {
        if (object == null) {
            return null;
        }
        if (((String)object).isEmpty()) {
            return object;
        }
        if (((String)object).length() > 1 && Character.isUpperCase(((String)object).charAt(1)) && Character.isUpperCase(((String)object).charAt(0))) {
            return object;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        cArray[0] = Character.toLowerCase((char)object[0]);
        return new String((char[])object);
    }

    private static String getSubstringIfPrefixMatches(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }
}

