/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event.stax;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.stax.BodyEvent;
import ch.qos.logback.core.joran.event.stax.EndEvent;
import ch.qos.logback.core.joran.event.stax.StartEvent;
import ch.qos.logback.core.joran.event.stax.StaxEvent;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class StaxEventRecorder
extends ContextAwareBase {
    List<StaxEvent> eventList = new ArrayList<StaxEvent>();
    ElementPath globalElementPath = new ElementPath();

    public StaxEventRecorder(Context context) {
        this.setContext(context);
    }

    public void recordEvents(InputStream object) throws JoranException {
        try {
            object = XMLInputFactory.newInstance().createXMLEventReader((InputStream)object);
            this.read((XMLEventReader)object);
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", xMLStreamException);
        }
    }

    public List<StaxEvent> getEventList() {
        return this.eventList;
    }

    private void read(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            switch (xMLEvent.getEventType()) {
                case 1: {
                    this.addStartElement(xMLEvent);
                    break;
                }
                case 4: {
                    this.addCharacters(xMLEvent);
                    break;
                }
                case 2: {
                    this.addEndEvent(xMLEvent);
                }
            }
        }
    }

    private void addStartElement(XMLEvent object) {
        object = object.asStartElement();
        String string = object.getName().getLocalPart();
        this.globalElementPath.push(string);
        ElementPath elementPath = this.globalElementPath.duplicate();
        object = new StartEvent(elementPath, string, object.getAttributes(), object.getLocation());
        this.eventList.add((StaxEvent)object);
    }

    private void addCharacters(XMLEvent object) {
        Characters characters = object.asCharacters();
        StaxEvent staxEvent = this.getLastEvent();
        if (staxEvent instanceof BodyEvent) {
            ((BodyEvent)staxEvent).append(characters.getData());
            return;
        }
        if (!characters.isWhiteSpace()) {
            object = new BodyEvent(characters.getData(), object.getLocation());
            this.eventList.add((StaxEvent)object);
        }
    }

    private void addEndEvent(XMLEvent object) {
        object = object.asEndElement();
        String string = object.getName().getLocalPart();
        object = new EndEvent(string, object.getLocation());
        this.eventList.add((StaxEvent)object);
        this.globalElementPath.pop();
    }

    StaxEvent getLastEvent() {
        if (this.eventList.isEmpty()) {
            return null;
        }
        int n2 = this.eventList.size();
        if (n2 == 0) {
            return null;
        }
        return this.eventList.get(n2 - 1);
    }
}

